/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.jboss.maven.plugins.jdocbook.Format;
import org.jboss.maven.plugins.jdocbook.Options;
import org.jboss.maven.plugins.jdocbook.gen.RenderingException;
import org.jboss.maven.plugins.jdocbook.gen.XSLTException;
import org.jboss.maven.plugins.jdocbook.gen.util.Formatting;
import org.jboss.maven.plugins.jdocbook.gen.util.StandardDocBookFormatSpecification;

public abstract class AbstractDocBookMojo
extends AbstractMojo {
    public static final String PLUGIN_NAME = "jdocbook";
    protected MavenProject project;
    protected Set projectArtifacts;
    protected List pluginArtifacts;
    protected ArchiverManager archiverManager;
    protected MavenProjectHelper projectHelper;
    protected String sourceDocumentName;
    protected File sourceDirectory;
    protected Resource imageResource;
    protected Resource cssResource;
    protected File targetDirectory;
    protected File stagingDirectory;
    protected Format[] formats;
    protected String masterTranslationArtifactId;
    protected File masterTranslationFile;
    protected String fontConfig;
    protected boolean attach = true;
    protected Options options;

    protected abstract void process(Formatting[] var1) throws RenderingException, XSLTException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.process(this.buildFormattings());
        }
        catch (XSLTException e) {
            throw new MojoExecutionException("XSLT problem", (Exception)e);
        }
        catch (RenderingException e) {
            throw new MojoExecutionException("Rendering problem", (Exception)e);
        }
    }

    private Formatting[] buildFormattings() {
        Formatting[] formattings = new Formatting[this.formats.length];
        for (int i = 0; i < this.formats.length; ++i) {
            formattings[i] = new Formatting(StandardDocBookFormatSpecification.parse(this.formats[i].getFormatName()), this.formats[i]);
        }
        return formattings;
    }

    protected void processArtifacts(ArtifactProcessor processor) {
        this.processProjectArtifacts(processor);
        this.processPluginArtifacts(processor);
    }

    protected void processProjectArtifacts(ArtifactProcessor processor) {
        this.processArtifacts(processor, this.projectArtifacts);
    }

    protected void processPluginArtifacts(ArtifactProcessor processor) {
        this.processArtifacts(processor, this.pluginArtifacts);
    }

    private void processArtifacts(ArtifactProcessor processor, Collection artifacts) {
        Iterator itr = artifacts.iterator();
        while (itr.hasNext()) {
            processor.process((Artifact)itr.next());
        }
    }

    protected static interface ArtifactProcessor {
        public void process(Artifact var1);
    }
}

