/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;
import org.jboss.maven.plugins.jdocbook.gen.RenderingException;
import org.jboss.maven.plugins.jdocbook.gen.XSLTException;
import org.jboss.maven.plugins.jdocbook.gen.format.FormatHandlerFactory;
import org.jboss.maven.plugins.jdocbook.gen.util.Formatting;

public class GenerationMojo
extends AbstractDocBookMojo {
    protected void process(Formatting[] formattings) throws XSLTException, RenderingException {
        if (!this.sourceDirectory.exists()) {
            this.getLog().info((CharSequence)("sourceDirectory [" + this.sourceDirectory.getAbsolutePath() + "] did not exist"));
            return;
        }
        File source = new File(this.sourceDirectory, this.sourceDocumentName);
        if (!source.exists()) {
            this.getLog().info((CharSequence)("source [" + source.getAbsolutePath() + "] did not exist"));
            return;
        }
        if (!this.targetDirectory.exists()) {
            FileUtils.mkdir((String)this.targetDirectory.getAbsolutePath());
        }
        if (this.options.getDocbookVersion() == null) {
            this.processArtifacts(new AbstractDocBookMojo.ArtifactProcessor(){

                public void process(Artifact artifact) {
                    if ("net.sf.docbook".equals(artifact.getGroupId()) && "docbook".equals(artifact.getArtifactId())) {
                        GenerationMojo.this.getLog().debug((CharSequence)("Found docbook version : " + artifact.getVersion()));
                        if (GenerationMojo.this.options.getDocbookVersion() != null) {
                            GenerationMojo.this.getLog().warn((CharSequence)"found multiple docbook versions");
                        }
                        GenerationMojo.this.options.setDocbookVersion(artifact.getVersion());
                    }
                }
            });
        }
        File fontConfigFile = null;
        if (this.fontConfig != null) {
            File tmp;
            this.getLog().debug((CharSequence)("checking for fontConfig existence [" + this.fontConfig + "]"));
            if (this.stagingDirectory != null && (tmp = new File(this.stagingDirectory, this.fontConfig)).exists()) {
                this.getLog().info((CharSequence)("using font configuration : " + tmp.getAbsolutePath()));
                fontConfigFile = tmp;
            }
        }
        FormatHandlerFactory formatHandlerFactory = new FormatHandlerFactory(this.options, source, this.targetDirectory, this.stagingDirectory, fontConfigFile, this.project, this.getLog());
        for (int i = 0; i < formattings.length; ++i) {
            formatHandlerFactory.buildFormatHandler(formattings[i]).render(source);
        }
    }
}

