/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;
import org.jboss.maven.plugins.jdocbook.gen.RenderingException;
import org.jboss.maven.plugins.jdocbook.gen.format.FormatHandlerFactory;
import org.jboss.maven.plugins.jdocbook.gen.util.Formatting;

public class PackageMojo
extends AbstractDocBookMojo {
    protected void process(Formatting[] formattings) throws RenderingException {
        File source = new File(this.sourceDirectory, this.sourceDocumentName);
        FormatHandlerFactory formatHandlerFactory = new FormatHandlerFactory(this.options, source, this.targetDirectory, this.stagingDirectory, null, this.project, this.getLog());
        File projectArtifactFile = new File(this.targetDirectory, this.project.getBuild().getFinalName() + ".war");
        JarArchiver archiver = new JarArchiver();
        archiver.setDestFile(projectArtifactFile);
        try {
            for (int i = 0; i < formattings.length; ++i) {
                archiver.addDirectory(new File(this.targetDirectory, formattings[i].getFormatName()), formattings[i].getFormatName() + "/");
                if (!this.attach) continue;
                formatHandlerFactory.buildFormatHandler(formattings[i]).attachOutput(source, this.projectHelper);
            }
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new RenderingException("Unable to create archive [" + projectArtifactFile.getAbsolutePath() + "]", e);
        }
        catch (ArchiverException e) {
            throw new RenderingException("Unable to populate archive [" + projectArtifactFile.getAbsolutePath() + "]", e);
        }
        this.project.getArtifact().setFile(projectArtifactFile);
    }
}

