/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;
import org.jboss.maven.plugins.jdocbook.gen.RenderingException;
import org.jboss.maven.plugins.jdocbook.gen.util.Formatting;
import org.jboss.maven.plugins.jdocbook.revdiff.Diff;
import org.jboss.maven.plugins.jdocbook.revdiff.DiffCreator;
import org.jboss.maven.plugins.jdocbook.revdiff.GenerationException;
import org.jboss.maven.plugins.jdocbook.revdiff.TranslationReportGenerator;

public class TranslationDiffReport
extends AbstractDocBookMojo
implements MavenReport {
    public static final String NAME = "translation-diff-report";
    private File reportOutputDirectory;

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle(NAME, locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private String buildReportFileName() {
        return this.getOutputName() + ".html";
    }

    protected void process(Formatting[] formattings) throws RenderingException {
        try {
            this.generateReport(Locale.getDefault());
        }
        catch (GenerationException t) {
            throw new RenderingException("An error has occurred in translation-diff-report report generation.", t);
        }
    }

    public String getOutputName() {
        return NAME;
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.name");
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.description");
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public void setReportOutputDirectory(File dir) {
        this.reportOutputDirectory = dir;
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.project.getReporting().getOutputDirectory());
        }
        return this.reportOutputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return this.masterTranslationArtifactId != null || this.masterTranslationFile != null && this.masterTranslationFile.exists();
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            this.generateReport(locale);
        }
        catch (GenerationException e) {
            throw new MavenReportException("error generating report", (Exception)e);
        }
    }

    private void generateReport(Locale locale) throws GenerationException {
        this.getLog().debug((CharSequence)"starting jdocbook:diff goal execution");
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"project is documentation master (or no master defined)");
            return;
        }
        File master = this.masterTranslationFile;
        if (master == null) {
            MasterTranslationLocator locator = new MasterTranslationLocator();
            this.processArtifacts(locator);
            master = locator.located.getFile();
        }
        if (master == null) {
            throw new GenerationException("unable to locate master source");
        }
        File translation = new File(this.sourceDirectory, this.sourceDocumentName);
        this.getLog().debug((CharSequence)("       master : " + master.getAbsolutePath()));
        this.getLog().debug((CharSequence)("  translation : " + translation.getAbsolutePath()));
        File output = new File(this.getReportOutputDirectory(), this.buildReportFileName());
        this.prepReportFile(output);
        DiffCreator diffCreator = new DiffCreator(this.options.isXincludeSupported(), this.getLog());
        Diff diff = diffCreator.findDiff(master, translation);
        TranslationReportGenerator generator = new TranslationReportGenerator(this.sourceDirectory, this.getBundle(locale), this.getLog());
        generator.generate(diff, output, locale.toString());
    }

    private void prepReportFile(File reportFile) throws GenerationException {
        if (reportFile.exists()) {
            reportFile.delete();
        }
        if (!reportFile.exists()) {
            try {
                reportFile.createNewFile();
            }
            catch (IOException e) {
                throw new GenerationException("unable to prep report file [" + reportFile.getAbsolutePath() + "]");
            }
        }
    }

    class MasterTranslationLocator
    implements AbstractDocBookMojo.ArtifactProcessor {
        private final String groupId;
        private Artifact located;

        MasterTranslationLocator() {
            this.groupId = TranslationDiffReport.this.project.getGroupId();
        }

        public void process(Artifact artifact) {
            if (this.groupId.equals(artifact.getGroupId()) && TranslationDiffReport.this.masterTranslationArtifactId.equals(artifact.getArtifactId())) {
                if (this.located != null) {
                    TranslationDiffReport.this.getLog().warn((CharSequence)"duplicate matching master found");
                }
                this.located = artifact;
            }
        }
    }
}

