/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.gen.format;

import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.maven.plugins.jdocbook.gen.RenderingException;
import org.jboss.maven.plugins.jdocbook.gen.XSLTException;
import org.jboss.maven.plugins.jdocbook.gen.format.FormatHandler;
import org.jboss.maven.plugins.jdocbook.gen.format.FormatHandlerFactory;
import org.jboss.maven.plugins.jdocbook.gen.util.Formatting;
import org.jboss.maven.plugins.jdocbook.gen.util.ResourceHelper;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class BasicFormatHandler
implements FormatHandler {
    public static final String DTD_VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    public static final String DTD_LOADING_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected final FormatHandlerFactory factory;
    protected final Formatting formatting;

    public BasicFormatHandler(FormatHandlerFactory factory, Formatting formatting) {
        this.factory = factory;
        this.formatting = formatting;
    }

    public File prepareDirectory() throws RenderingException {
        File target = new File(this.factory.getTargetDirectory(), this.formatting.getFormatName());
        if (!target.exists()) {
            FileUtils.mkdir((String)target.getAbsolutePath());
        }
        if (this.formatting.isImageCopyingRequired() && this.factory.getStagingDirectory().exists()) {
            File cssBase;
            File imageBase = new File(this.factory.getStagingDirectory(), "images");
            if (imageBase.exists()) {
                try {
                    FileUtils.copyDirectoryStructure((File)imageBase, (File)target);
                }
                catch (IOException e) {
                    throw new RenderingException("unable to copy images", e);
                }
            }
            if ((cssBase = new File(this.factory.getStagingDirectory(), "css")).exists()) {
                try {
                    FileUtils.copyDirectoryStructure((File)cssBase, (File)target);
                }
                catch (IOException e) {
                    throw new RenderingException("unable to copy css", e);
                }
            }
        }
        return target;
    }

    public void attachOutput(File sourceFile, MavenProjectHelper projectHelper) throws RenderingException {
        File rawOutputDir = new File(this.factory.getTargetDirectory(), this.formatting.getFormatName());
        String warName = this.factory.getMavenProject().getBuild().getFinalName() + "-" + this.formatting.getFormatName() + ".war";
        File attachmentDirectory = new File(this.factory.getTargetDirectory(), "../attach");
        if (!attachmentDirectory.exists()) {
            attachmentDirectory.mkdirs();
        }
        File war = new File(attachmentDirectory, warName);
        JarArchiver archiver = new JarArchiver();
        archiver.setDestFile(war);
        try {
            archiver.addDirectory(rawOutputDir);
            archiver.createArchive();
        }
        catch (IOException e) {
            throw new RenderingException("Unable to create archive [" + war.getAbsolutePath() + "]", e);
        }
        catch (ArchiverException e) {
            throw new RenderingException("Unable to populate archive [" + war.getAbsolutePath() + "]", e);
        }
        projectHelper.attachArtifact(this.factory.getMavenProject(), "war", this.formatting.getFormatName(), war);
    }

    public final void render(File sourceFile) throws RenderingException, XSLTException {
        this.getLog().debug((CharSequence)("starting formatting [" + this.formatting.getFormatName() + "]"));
        File target = this.prepareTarget(this.prepareDirectory(), sourceFile);
        Transformer transformer = this.buildTransformer(target);
        Source transformationSource = this.buildSource(sourceFile);
        Result transformationResult = this.buildResult(target);
        try {
            transformer.transform(transformationSource, transformationResult);
        }
        catch (TransformerException e) {
            throw new XSLTException("error performing translation [" + e.getLocationAsString() + "] : " + e.getMessage(), e);
        }
        finally {
            this.releaseResult(transformationResult);
        }
    }

    private File prepareTarget(File directory, File sourceFile) throws RenderingException {
        String targetFileName = this.deduceTargetFileName(sourceFile);
        this.getLog().debug((CharSequence)("preparing target file [" + targetFileName + "]"));
        File target = new File(directory, targetFileName);
        if (target.exists() && !target.delete()) {
            this.getLog().warn((CharSequence)("unable to clean up previous output file [" + target.getAbsolutePath() + "]"));
        }
        if (!target.exists()) {
            try {
                target.createNewFile();
            }
            catch (IOException e) {
                throw new RenderingException("unable to create output file [" + target.getAbsolutePath() + "]", e);
            }
        }
        return target;
    }

    private String deduceTargetFileName(File source) {
        return this.formatting.getNamingStrategy().deduceTargetFileName(source);
    }

    protected Transformer buildTransformer(File targetFile) throws RenderingException, XSLTException {
        URL transformationStylesheet = this.resolveTransformationStylesheet();
        Transformer transformer = this.factory.getTransformerFactory().buildTransformer(this.formatting, transformationStylesheet);
        if (this.formatting.isImagePathSettingRequired()) {
            String imgSrcPath = this.factory.getStagingDirectory().getAbsolutePath() + "/images/";
            this.getLog().debug((CharSequence)("setting 'img.src.path' [" + imgSrcPath + "]"));
            transformer.setParameter("img.src.path", imgSrcPath);
        }
        if (this.factory.getOptions().isUseRelativeImageUris()) {
            this.getLog().debug((CharSequence)"enforcing retention of relative image URIs");
            transformer.setParameter("keep.relative.image.uris", "0");
        }
        if (this.formatting.isDoingChunking()) {
            this.getLog().debug((CharSequence)"Chunking output.");
            String rootFilename = targetFile.getName();
            rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
            transformer.setParameter("root.filename", rootFilename);
            transformer.setParameter("base.dir", targetFile.getParent() + File.separator);
            transformer.setParameter("manifest.in.base.dir", "1");
        }
        return transformer;
    }

    protected final URL resolveTransformationStylesheet() throws RenderingException {
        return ResourceHelper.requireResource(this.formatting.getStylesheetResource());
    }

    private Source buildSource(File sourceFile) throws RenderingException {
        try {
            CatalogResolver resolver = this.factory.getCatalogResolver();
            SAXParserFactory factory = this.createParserFactory();
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setEntityResolver((EntityResolver)resolver);
            reader.setFeature(DTD_LOADING_FEATURE, false);
            reader.setFeature(DTD_VALIDATION_FEATURE, false);
            return new SAXSource(reader, new InputSource(sourceFile.getAbsolutePath()));
        }
        catch (ParserConfigurationException e) {
            throw new RenderingException("unable to build SAX Parser", e);
        }
        catch (SAXException e) {
            throw new RenderingException("unable to build SAX Parser", e);
        }
    }

    protected final SAXParserFactory createParserFactory() {
        SAXParserFactoryImpl parserFactory = new SAXParserFactoryImpl();
        ((SAXParserFactory)parserFactory).setXIncludeAware(this.factory.getOptions().isXincludeSupported());
        return parserFactory;
    }

    protected Result buildResult(File targetFile) throws RenderingException, XSLTException {
        return new StreamResult(targetFile);
    }

    protected void releaseResult(Result transformationResult) {
    }

    protected Log getLog() {
        return this.factory.getLog();
    }
}

