/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.gen.format;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.jboss.maven.plugins.jdocbook.Options;
import org.jboss.maven.plugins.jdocbook.gen.format.BasicFormatHandler;
import org.jboss.maven.plugins.jdocbook.gen.format.FormatHandler;
import org.jboss.maven.plugins.jdocbook.gen.format.PdfFormatHandler;
import org.jboss.maven.plugins.jdocbook.gen.util.Formatting;
import org.jboss.maven.plugins.jdocbook.gen.util.StandardDocBookFormatSpecification;
import org.jboss.maven.plugins.jdocbook.gen.util.TransformerType;
import org.jboss.maven.plugins.jdocbook.gen.xslt.TransformerFactory;
import org.jboss.maven.plugins.jdocbook.gen.xslt.catalog.AbstractCatalogManager;
import org.jboss.maven.plugins.jdocbook.gen.xslt.catalog.ExplicitCatalogManager;
import org.jboss.maven.plugins.jdocbook.gen.xslt.catalog.ImplicitCatalogManager;

public class FormatHandlerFactory {
    private final Options options;
    private final File source;
    private final File targetDirectory;
    private final File stagingDirectory;
    private final File fontConfig;
    private final MavenProject mavenProject;
    private final Log log;
    private CatalogResolver catalogResolver;
    private TransformerFactory transformerFactory;

    public FormatHandlerFactory(Options options, File source, File targetDirectory, File stagingDirectory, File fontConfig, MavenProject mavenProject, Log log) {
        this.options = options;
        this.source = source;
        this.targetDirectory = targetDirectory;
        this.stagingDirectory = stagingDirectory;
        this.fontConfig = fontConfig;
        this.mavenProject = mavenProject;
        this.log = log;
    }

    public Options getOptions() {
        return this.options;
    }

    public File getSource() {
        return this.source;
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }

    public File getStagingDirectory() {
        return this.stagingDirectory;
    }

    public File getFontConfig() {
        return this.fontConfig;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public Log getLog() {
        return this.log;
    }

    public CatalogResolver getCatalogResolver() {
        if (this.catalogResolver == null) {
            AbstractCatalogManager catalogManager = this.options.getCatalogs() == null || this.options.getCatalogs().length == 0 ? new ImplicitCatalogManager() : new ExplicitCatalogManager(this.options.getCatalogs());
            this.catalogResolver = new CatalogResolver((CatalogManager)catalogManager);
        }
        return this.catalogResolver;
    }

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = new TransformerFactory(TransformerType.parse(this.options.getXmlTransformerType()), this.options.getTransformerParameters(), this.getCatalogResolver(), this.options.getDocbookVersion());
        }
        return this.transformerFactory;
    }

    public FormatHandler buildFormatHandler(Formatting formatting) {
        if (formatting.getFormatName().equals(StandardDocBookFormatSpecification.PDF.getName())) {
            return new PdfFormatHandler(this, formatting);
        }
        return new BasicFormatHandler(this, formatting);
    }
}

