/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.gen.format;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.jboss.maven.plugins.jdocbook.gen.RenderingException;
import org.jboss.maven.plugins.jdocbook.gen.format.BasicFormatHandler;
import org.jboss.maven.plugins.jdocbook.gen.format.FormatHandlerFactory;
import org.jboss.maven.plugins.jdocbook.gen.util.Formatting;

public class PdfFormatHandler
extends BasicFormatHandler {
    public PdfFormatHandler(FormatHandlerFactory factory, Formatting formatting) {
        super(factory, formatting);
    }

    protected Result buildResult(File targetFile) throws RenderingException {
        this.getLog().info((CharSequence)("building formatting result [" + targetFile.getAbsolutePath() + "]"));
        return new ResultImpl(targetFile);
    }

    private void prepareFonts(FopFactory fopFactory) throws RenderingException {
        if (this.factory.getFontConfig() != null) {
            try {
                fopFactory.setUserConfig(this.factory.getFontConfig());
            }
            catch (Throwable t) {
                throw new RenderingException("unable to properly prepare FOP fonts", t);
            }
        }
    }

    protected void releaseResult(Result transformationResult) {
        ((ResultImpl)transformationResult).release();
    }

    private class ResultImpl
    extends SAXResult {
        private OutputStream outputStream;

        public ResultImpl(File targetFile) throws RenderingException {
            try {
                FopFactory fopFactory = FopFactory.newInstance();
                PdfFormatHandler.this.prepareFonts(fopFactory);
                this.outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
                FOUserAgent fopUserAgent = fopFactory.newFOUserAgent();
                fopUserAgent.setProducer("jDocBook Plugin for Maven");
                Fop fop = fopFactory.newFop("application/pdf", fopUserAgent, this.outputStream);
                this.setHandler(fop.getDefaultHandler());
            }
            catch (Throwable t) {
                throw new RenderingException("error building transformation result [" + targetFile.getAbsolutePath() + "]", t);
            }
        }

        private void release() {
            if (this.outputStream == null) {
                return;
            }
            try {
                this.outputStream.flush();
                this.outputStream.close();
            }
            catch (IOException e) {
                PdfFormatHandler.this.getLog().warn((CharSequence)"error releasing I/O resources", (Throwable)e);
            }
        }
    }
}

