/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.gen.util;

import java.io.File;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.maven.plugins.jdocbook.Format;
import org.jboss.maven.plugins.jdocbook.gen.util.StandardDocBookFormatSpecification;

public class Formatting {
    private final String formatName;
    private final String stylesheetResource;
    private final boolean imagePathSettingRequired;
    private final boolean imageCopyingRequired;
    private final boolean doingChunking;
    private final StandardDocBookFormatSpecification standardDocBookSpec;
    private final TargetNamingStrategy namingStrategy;

    public Formatting(StandardDocBookFormatSpecification standardDocBookSpec, Format userSpec) {
        if (!standardDocBookSpec.getName().equals(userSpec.getFormatName())) {
            throw new IllegalArgumentException("formatting type mismatch");
        }
        this.standardDocBookSpec = standardDocBookSpec;
        this.formatName = userSpec.getFormatName();
        this.stylesheetResource = userSpec.getStylesheetResource() == null ? standardDocBookSpec.getStylesheetResource() : userSpec.getStylesheetResource();
        this.imageCopyingRequired = userSpec.getImageCopyingRequired() == null ? standardDocBookSpec.isImageCopyingRequired() : userSpec.getImageCopyingRequired().booleanValue();
        this.imagePathSettingRequired = userSpec.getImagePathSettingRequired() == null ? standardDocBookSpec.isImagePathSettingRequired() : userSpec.getImagePathSettingRequired().booleanValue();
        this.doingChunking = userSpec.getDoingChunking() == null ? standardDocBookSpec.isDoingChunking() : userSpec.getDoingChunking().booleanValue();
        this.namingStrategy = new TargetNamingStrategy(standardDocBookSpec, userSpec);
    }

    public String getFormatName() {
        return this.formatName;
    }

    public StandardDocBookFormatSpecification getStandardDocBookSpec() {
        return this.standardDocBookSpec;
    }

    public String getStylesheetResource() {
        return this.stylesheetResource;
    }

    public boolean isImagePathSettingRequired() {
        return this.imagePathSettingRequired;
    }

    public boolean isImageCopyingRequired() {
        return this.imageCopyingRequired;
    }

    public boolean isDoingChunking() {
        return this.doingChunking;
    }

    public TargetNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public static class TargetNamingStrategy {
        private String targetFileExtension;
        private String finalName;

        public TargetNamingStrategy(StandardDocBookFormatSpecification standardDocBookSpec, Format userSpec) {
            if (userSpec.getFinalName() != null) {
                this.targetFileExtension = null;
                this.finalName = userSpec.getFinalName();
            } else {
                this.targetFileExtension = userSpec.getTargetFileExtension() == null ? standardDocBookSpec.getStandardFileExtension() : userSpec.getTargetFileExtension();
                this.finalName = null;
            }
        }

        public String deduceTargetFileName(File source) {
            return this.finalName == null ? FileUtils.basename((String)source.getAbsolutePath()) + this.targetFileExtension : this.finalName;
        }
    }
}

