/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.gen.util;

public class StandardDocBookFormatSpecification {
    public static final StandardDocBookFormatSpecification ECLIPSE = new HtmlBasedStandardDocBookFormat("eclipse", "/eclipse/eclipse.xsl");
    public static final StandardDocBookFormatSpecification HTML = new HtmlBasedStandardDocBookFormat("html", "/html/chunk.xsl");
    public static final StandardDocBookFormatSpecification HTML_SINGLE = new HtmlBasedStandardDocBookFormat("html_single", "/html/docbook.xsl", false);
    public static final StandardDocBookFormatSpecification HTMLHELP = new HtmlBasedStandardDocBookFormat("htmlhelp", "/htmlhelp/htmlhelp.xsl");
    public static final StandardDocBookFormatSpecification JAVAHELP = new HtmlBasedStandardDocBookFormat("javahelp", "/javahelp/javahelp.xsl");
    public static final StandardDocBookFormatSpecification MAN = new HtmlBasedStandardDocBookFormat("man", "/manpages/docbook.xsl", false);
    public static final StandardDocBookFormatSpecification PDF = new StandardDocBookFormatSpecification("pdf", "pdf", "/fo/docbook.xsl", true, false, false);
    public static final StandardDocBookFormatSpecification WEBSITE = new HtmlBasedStandardDocBookFormat("website", "/website/website.xsl", false);
    public static final StandardDocBookFormatSpecification XHTML = new StandardDocBookFormatSpecification("xhtml", "xhtml", "/xhtml/docbook.xsl", false, true, false);
    private final String name;
    private final String standardFileExtension;
    private final String stylesheetResource;
    private final boolean imagePathSettingRequired;
    private final boolean imageCopyingRequired;
    private final boolean doingChunking;

    public StandardDocBookFormatSpecification(String name, String standardFileExtension, String stylesheetResource, boolean imagePathSettingRequired, boolean imageCopyingRequired, boolean doingChunking) {
        this.name = name;
        this.standardFileExtension = standardFileExtension;
        this.stylesheetResource = stylesheetResource;
        this.imagePathSettingRequired = imagePathSettingRequired;
        this.imageCopyingRequired = imageCopyingRequired;
        this.doingChunking = doingChunking;
    }

    public String getName() {
        return this.name;
    }

    public String getStandardFileExtension() {
        return this.standardFileExtension;
    }

    public String getStylesheetResource() {
        return this.stylesheetResource;
    }

    public boolean isImagePathSettingRequired() {
        return this.imagePathSettingRequired;
    }

    public boolean isImageCopyingRequired() {
        return this.imageCopyingRequired;
    }

    public boolean isDoingChunking() {
        return this.doingChunking;
    }

    public static StandardDocBookFormatSpecification parse(String name) {
        if (StandardDocBookFormatSpecification.ECLIPSE.name.equals(name)) {
            return ECLIPSE;
        }
        if (StandardDocBookFormatSpecification.HTML.name.equals(name)) {
            return HTML;
        }
        if (StandardDocBookFormatSpecification.HTML_SINGLE.name.equals(name)) {
            return HTML_SINGLE;
        }
        if (StandardDocBookFormatSpecification.HTMLHELP.name.equals(name)) {
            return HTMLHELP;
        }
        if (StandardDocBookFormatSpecification.JAVAHELP.name.equals(name)) {
            return JAVAHELP;
        }
        if (StandardDocBookFormatSpecification.MAN.name.equals(name)) {
            return MAN;
        }
        if (StandardDocBookFormatSpecification.PDF.name.equals(name)) {
            return PDF;
        }
        if (StandardDocBookFormatSpecification.WEBSITE.name.equals(name)) {
            return WEBSITE;
        }
        if (StandardDocBookFormatSpecification.XHTML.name.equals(name)) {
            return XHTML;
        }
        return null;
    }

    private static class HtmlBasedStandardDocBookFormat
    extends StandardDocBookFormatSpecification {
        private HtmlBasedStandardDocBookFormat(String name, String stylesheetResource) {
            this(name, stylesheetResource, true);
        }

        private HtmlBasedStandardDocBookFormat(String name, String stylesheetResource, boolean doingChunking) {
            super(name, "html", stylesheetResource, false, true, doingChunking);
        }
    }
}

