/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.gen.xslt;

import com.icl.saxon.Controller;
import com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.jboss.maven.plugins.jdocbook.gen.XSLTException;
import org.jboss.maven.plugins.jdocbook.gen.util.Formatting;
import org.jboss.maven.plugins.jdocbook.gen.util.NoOpWriter;
import org.jboss.maven.plugins.jdocbook.gen.util.ResourceHelper;
import org.jboss.maven.plugins.jdocbook.gen.util.StandardDocBookFormatSpecification;
import org.jboss.maven.plugins.jdocbook.gen.util.TransformerType;
import org.jboss.maven.plugins.jdocbook.gen.xslt.resolve.CurrentVersionResolver;
import org.jboss.maven.plugins.jdocbook.gen.xslt.resolve.ExplicitUrnResolver;
import org.jboss.maven.plugins.jdocbook.gen.xslt.resolve.RelativeJarUriResolver;
import org.jboss.maven.plugins.jdocbook.gen.xslt.resolve.ResolverChain;
import org.jboss.maven.plugins.jdocbook.gen.xslt.resolve.VersionResolver;

public class TransformerFactory {
    private final TransformerType transformerType;
    private final Properties transformerParameters;
    private final CatalogResolver catalogResolver;
    private final String docbookVersion;

    public TransformerFactory(TransformerType transformerType, Properties transformerParameters, CatalogResolver catalogResolver, String docbookVersion) {
        this.transformerType = transformerType;
        this.transformerParameters = transformerParameters;
        this.catalogResolver = catalogResolver;
        this.docbookVersion = docbookVersion;
    }

    public Transformer buildTransformer(Formatting formatting, URL customStylesheet) throws XSLTException {
        Transformer transformer;
        URIResolver uriResolver = this.buildUriResolver(formatting.getStandardDocBookSpec());
        javax.xml.transform.TransformerFactory transformerFactory = this.buildTransformerFactory();
        transformerFactory.setURIResolver(uriResolver);
        URL xsltStylesheet = customStylesheet == null ? ResourceHelper.requireResource(formatting.getStylesheetResource()) : customStylesheet;
        try {
            StreamSource source = new StreamSource(xsltStylesheet.openStream(), xsltStylesheet.toExternalForm());
            transformer = transformerFactory.newTransformer(source);
        }
        catch (IOException e) {
            throw new XSLTException("problem opening stylesheet", e);
        }
        catch (TransformerConfigurationException e) {
            throw new XSLTException("unable to build transformer", e);
        }
        transformer.setURIResolver(uriResolver);
        this.applyParameters(transformer);
        if (transformer instanceof Controller) {
            Controller controller = (Controller)transformer;
            try {
                controller.makeMessageEmitter();
                controller.getMessageEmitter().setWriter((Writer)new NoOpWriter());
            }
            catch (TransformerException te) {
                // empty catch block
            }
        }
        return transformer;
    }

    private javax.xml.transform.TransformerFactory buildTransformerFactory() {
        if (this.transformerType == TransformerType.XALAN) {
            return new TransformerFactoryImpl();
        }
        return new com.icl.saxon.TransformerFactoryImpl();
    }

    private void applyParameters(Transformer transformer) {
        transformer.setParameter("fop.extensions", "0");
        transformer.setParameter("fop1.extensions", "1");
        if (this.transformerParameters == null) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> itr = this.transformerParameters.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> entry = itr.next();
            transformer.setParameter((String)entry.getKey(), entry.getValue());
        }
    }

    public URIResolver buildUriResolver(StandardDocBookFormatSpecification formatType) throws XSLTException {
        ResolverChain resolverChain = new ResolverChain();
        if (formatType != null) {
            resolverChain.addResolver(new ExplicitUrnResolver(formatType));
        }
        resolverChain.addResolver(new CurrentVersionResolver());
        if (this.docbookVersion != null) {
            resolverChain.addResolver(new VersionResolver(this.docbookVersion));
        }
        resolverChain.addResolver(new RelativeJarUriResolver());
        resolverChain.addResolver((URIResolver)this.catalogResolver);
        return resolverChain;
    }
}

