/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.gen.xslt.resolve;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.maven.plugins.jdocbook.gen.XSLTException;
import org.jboss.maven.plugins.jdocbook.gen.util.ResourceHelper;
import org.jboss.maven.plugins.jdocbook.gen.util.StandardDocBookFormatSpecification;
import org.jboss.maven.plugins.jdocbook.gen.xslt.resolve.BasicUrnResolver;

public class ExplicitUrnResolver
extends BasicUrnResolver {
    private final StandardDocBookFormatSpecification formatType;

    public ExplicitUrnResolver(StandardDocBookFormatSpecification type) throws XSLTException {
        super("urn:docbook:stylesheet", ExplicitUrnResolver.createSource(type));
        this.formatType = type;
    }

    private static Source createSource(StandardDocBookFormatSpecification type) throws XSLTException {
        URL stylesheet = ResourceHelper.requireResource(type.getStylesheetResource());
        try {
            return new StreamSource(stylesheet.openStream(), stylesheet.toExternalForm());
        }
        catch (IOException e) {
            throw new XSLTException("could not locate DocBook stylesheet [" + type.getName() + "]", e);
        }
    }

    public String toString() {
        return super.toString() + " [" + this.formatType.getName() + "]";
    }
}

