/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.revdiff;

import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.logging.Log;
import org.jboss.maven.plugins.jdocbook.revdiff.BaselineHandler;
import org.jboss.maven.plugins.jdocbook.revdiff.Diff;
import org.jboss.maven.plugins.jdocbook.revdiff.GenerationException;
import org.jboss.maven.plugins.jdocbook.revdiff.TranslationHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class DiffCreator {
    private final XMLReader parser;
    private final Log log;

    public DiffCreator(boolean xincludeSupport, Log log) throws GenerationException {
        this.parser = this.generateParser(xincludeSupport);
        this.log = log;
    }

    public synchronized Diff findDiff(File master, File translation) throws GenerationException {
        HashMap catalog = new HashMap();
        BaselineHandler baselineHandler = new BaselineHandler(catalog);
        this.parser.setContentHandler(baselineHandler);
        try {
            this.parser.parse(master.getAbsolutePath());
        }
        catch (IOException e) {
            throw new GenerationException("unable to locate specified master [" + master.getAbsolutePath() + "]", e);
        }
        catch (SAXException e) {
            throw new GenerationException("error parsing master [" + master.getAbsolutePath() + "]", e);
        }
        this.log.debug((CharSequence)("encountered [" + catalog.size() + "] master content elements"));
        Diff diff = new Diff();
        TranslationHandler translationHandler = new TranslationHandler(catalog, diff);
        this.parser.setContentHandler(translationHandler);
        try {
            this.parser.parse(translation.getAbsolutePath());
        }
        catch (IOException e) {
            throw new GenerationException("unable to locate specified translation [" + translation.getAbsolutePath() + "]", e);
        }
        catch (SAXException e) {
            throw new GenerationException("error parsing translation [" + translation.getAbsolutePath() + "]", e);
        }
        translationHandler.finish();
        return diff;
    }

    private XMLReader generateParser(boolean xincludeSupport) throws GenerationException {
        try {
            XMLReader parser = this.createParserFactory(xincludeSupport).newSAXParser().getXMLReader();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return parser;
        }
        catch (SAXNotSupportedException e) {
            throw new GenerationException("unable to generate SAX Parser", e);
        }
        catch (SAXNotRecognizedException e) {
            throw new GenerationException("unable to generate SAX Parser", e);
        }
        catch (ParserConfigurationException e) {
            throw new GenerationException("unable to generate SAX Parser", e);
        }
        catch (SAXException e) {
            throw new GenerationException("unable to generate SAX Parser", e);
        }
    }

    private SAXParserFactory createParserFactory(boolean xincludeSupport) {
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        ((SAXParserFactory)factory).setXIncludeAware(xincludeSupport);
        return factory;
    }
}

