/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.revdiff;

import java.util.Iterator;
import java.util.Map;
import org.jboss.maven.plugins.jdocbook.revdiff.ContentItem;
import org.jboss.maven.plugins.jdocbook.revdiff.ContentItemDescriptor;
import org.jboss.maven.plugins.jdocbook.revdiff.Diff;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TranslationHandler
extends DefaultHandler {
    private final Map catalog;
    private final Diff diff;
    private Locator docLocator;

    public TranslationHandler(Map catalog, Diff diff) {
        this.catalog = catalog;
        this.diff = diff;
    }

    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) throws SAXException {
        String identifier = atts.getValue("id");
        if (identifier != null) {
            int revision = 0;
            if (atts.getValue("revision") != null) {
                revision = Integer.parseInt(atts.getValue("revision"));
            }
            ContentItemDescriptor translationState = new ContentItemDescriptor(this.docLocator.getSystemId(), qualifiedName, revision, this.docLocator.getLineNumber(), this.docLocator.getColumnNumber());
            ContentItem contentItem = (ContentItem)this.catalog.remove(identifier);
            if (contentItem == null) {
                if (revision != ContentItemDescriptor.REVISION_IGNORE) {
                    contentItem = new ContentItem(identifier);
                    contentItem.setTranslationDescriptor(translationState);
                    this.diff.addOnlyInTranslation(contentItem);
                }
            } else if (revision != contentItem.getMasterDescriptor().getRevision() && revision != ContentItemDescriptor.REVISION_IGNORE) {
                contentItem.setTranslationDescriptor(translationState);
                this.diff.addDiffRevision(contentItem);
            }
        }
    }

    public void finish() {
        Iterator itr = this.catalog.entrySet().iterator();
        while (itr.hasNext()) {
            ContentItem contentItem = (ContentItem)itr.next().getValue();
            itr.remove();
            this.diff.addOnlyInMaster(contentItem);
        }
    }
}

