/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook.revdiff;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;
import org.jboss.maven.plugins.jdocbook.revdiff.ContentItem;
import org.jboss.maven.plugins.jdocbook.revdiff.ContentItemDescriptor;
import org.jboss.maven.plugins.jdocbook.revdiff.Diff;
import org.jboss.maven.plugins.jdocbook.revdiff.GenerationException;

public class TranslationReportGenerator {
    private final String base;
    private final ResourceBundle bundle;
    private final Log log;

    public TranslationReportGenerator(File basedir, ResourceBundle bundle, Log log) {
        try {
            this.base = basedir.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("basedir was a malformed url");
        }
        log.debug((CharSequence)("constructing docbook diff report generator [base=" + this.base + "]"));
        this.bundle = bundle;
        this.log = log;
    }

    public void generate(Diff diff, File output, String translation) throws GenerationException {
        File outputDirectory;
        if (output.exists()) {
            this.log.debug((CharSequence)("cleaning up previous translation-diff report output [" + output.getAbsolutePath() + "]"));
            output.delete();
        }
        if (!(outputDirectory = output.getParentFile()).exists()) {
            String outputDirectoryPath = outputDirectory.getAbsolutePath();
            this.log.debug((CharSequence)("creating translation-diff report directory [" + outputDirectoryPath + "]"));
            FileUtils.mkdir((String)outputDirectoryPath);
        }
        try {
            output.createNewFile();
        }
        catch (IOException e) {
            throw new GenerationException("unable to create output file [" + output.getAbsolutePath() + "]", e);
        }
        try {
            FileWriter writer = new FileWriter(output);
            writer.write(this.pageHead(translation));
            writer.write("<table cellpadding=4>");
            writer.write(this.generateNewInMaster(diff));
            writer.write("<tr><td>&nbsp;</td></tr>");
            writer.write(this.generateDiffRevision(diff));
            writer.write("<tr><td>&nbsp;</td></tr>");
            writer.write(this.generateNewInTranslation(diff));
            writer.write("</table>");
            writer.write(this.pageFoot());
            writer.close();
        }
        catch (IOException e) {
            throw new GenerationException("error writing report [" + output.getAbsolutePath() + "]", e);
        }
    }

    private String pageHead(String translation) {
        StringBuffer buf = new StringBuffer(256);
        buf.append("<html><head><title>").append(this.bundle.getString("report.name")).append("</title></head><body><div align=\"center\">");
        buf.append("<h3>").append(this.bundle.getString("report.header")).append(" - ").append(translation).append("</h3>");
        return buf.toString();
    }

    private String pageFoot() {
        StringBuffer buf = new StringBuffer(256);
        buf.append("</div></body></html>");
        return buf.toString();
    }

    private String generateNewInMaster(Diff diff) {
        StringBuffer buf = new StringBuffer();
        Iterator itr = diff.getElementsOnlyInMaster();
        while (itr.hasNext()) {
            ContentItem contentItem = (ContentItem)itr.next();
            buf.append("<tr><td bgcolor=#eeeeee>ID: ").append(contentItem.getIdentifier()).append("</td></tr>");
            buf.append("<tr><td>");
            buf.append("<b>").append(this.formatReference(contentItem.getMasterDescriptor())).append("</b>");
            buf.append("</td></tr>");
        }
        String result = "";
        if (buf.length() > 0) {
            result = "<tr bgcolor=#cccccc><td><b>New in master:</b></td></tr>";
        }
        return result + buf.toString();
    }

    private String generateDiffRevision(Diff diff) {
        StringBuffer buf = new StringBuffer();
        Iterator itr = diff.getElementsDiffRevision();
        while (itr.hasNext()) {
            ContentItem contentItem = (ContentItem)itr.next();
            buf.append("<tr><td bgcolor=#eeeeee>ID: ").append(contentItem.getIdentifier()).append("</td></tr>");
            if (!contentItem.getMasterDescriptor().getElementName().equals(contentItem.getTranslationDescriptor().getElementName())) {
                buf.append("<tr><td bgcolor=#ee6666>");
                buf.append("Element names differ: ").append(contentItem.getMasterDescriptor().getElementName()).append("/").append(contentItem.getTranslationDescriptor().getElementName());
                buf.append("</td></tr>");
            }
            buf.append("<tr><td>");
            buf.append("Master: <b>").append(this.formatReference(contentItem.getMasterDescriptor())).append("</b>");
            buf.append("</td></tr>");
            buf.append("<tr><td>");
            buf.append("Translation: <b>").append(this.formatReference(contentItem.getTranslationDescriptor())).append("</b>");
            buf.append("</td></tr>");
            buf.append("<tr><td>");
            buf.append("Master Revision: ").append(contentItem.getMasterDescriptor().getRevision());
            buf.append("</td></tr>");
            buf.append("<tr><td>");
            buf.append("Translation Revision: ").append(contentItem.getTranslationDescriptor().getRevision());
            buf.append("</td></tr>");
        }
        String result = "";
        if (buf.length() > 0) {
            result = "<tr bgcolor=#cccccc><td><b>Translation needs update:</b></td></tr>";
        }
        return result + buf.toString();
    }

    private String generateNewInTranslation(Diff diff) {
        StringBuffer buf = new StringBuffer();
        Iterator itr = diff.getElementsOnlyInTranslation();
        while (itr.hasNext()) {
            ContentItem contentItem = (ContentItem)itr.next();
            buf.append("<tr><td bgcolor=#eeeeee>ID: ").append(contentItem.getIdentifier()).append("</td></tr>");
            buf.append("<tr><td>");
            buf.append("<b>").append(this.formatReference(contentItem.getTranslationDescriptor())).append("</b>");
            buf.append("</td></tr>");
        }
        String result = "";
        if (buf.length() > 0) {
            result = "<tr bgcolor=#cccccc><td><b>Only present in translation:</b></td></tr>";
        }
        return result + buf.toString();
    }

    private String formatReference(ContentItemDescriptor descriptor) {
        return this.makeSystemIdRelative(descriptor.getSourceSystemId()) + ":" + descriptor.getElementName() + " (" + descriptor.getRow() + "," + descriptor.getColumn() + ")";
    }

    private String makeSystemIdRelative(String systemId) {
        String systemIdUrl = this.toURL(systemId).toExternalForm();
        this.log.debug((CharSequence)("checking source [" + systemIdUrl + "] against base [" + this.base + "]"));
        if (systemIdUrl.startsWith(this.base)) {
            return systemIdUrl.substring(this.base.length());
        }
        return systemIdUrl;
    }

    private URL toURL(String systemId) {
        try {
            return new URL(systemId);
        }
        catch (MalformedURLException e) {
            throw new UnsupportedOperationException("unable to parse systemId [" + systemId + "] as URL");
        }
    }
}

