package org.jboss.jdocbook.xslt.resolve;

import java.net.URL;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

/**
 * 
 * Resolves classpath references from the given classloader using classpath:/
 * as the protocol handler
 * 
 * @author Pete Muir
 *
 */

public class ClasspathResolver implements URIResolver {

	private ClassLoader classLoader;
	
	public ClasspathResolver(ClassLoader classLoader) {
		this.classLoader = classLoader;
	}
	
	public Source resolve(String href, String base) throws TransformerException {
		
		// href would need to start with classpath:
		if ( !href.startsWith( "classpath:" ) ) {
			return null;
		}
		
		try {
			URL url = classLoader.getResource( href.substring(10) );
			return new StreamSource( url.openStream(), url.toExternalForm() );
		}
		catch ( Throwable t ) {
			return null;
		}
	}

}
