/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.i18n.gettext;

import java.io.File;
import java.util.Locale;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.Options;
import org.jboss.jdocbook.i18n.PoSynchronizer;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.I18nUtils;
import org.jboss.jdocbook.util.VCSDirectoryExclusionFilter;
import org.jboss.maven.shared.process.Executor;

public class PoSynchronizerImpl
implements PoSynchronizer {
    public void synchronizePo(File potDirectory, File translationDirectory, Locale translationLocale, Options options) throws JDocBookProcessException {
        if (!potDirectory.exists()) {
            options.getLog().info("skipping PO updates; POT directory did not exist : {0}", potDirectory);
            return;
        }
        File[] files = potDirectory.listFiles(new VCSDirectoryExclusionFilter());
        int X = files.length;
        for (int i = 0; i < X; ++i) {
            if (files[i].isDirectory()) {
                this.synchronizePo(new File(potDirectory, files[i].getName()), new File(translationDirectory, files[i].getName()), translationLocale, options);
                continue;
            }
            if (!I18nUtils.isPotFile(files[i])) continue;
            File translation = new File(translationDirectory, I18nUtils.determinePoFileName(files[i]));
            this.updateTranslation(files[i], translation, translationLocale, options);
        }
    }

    private void updateTranslation(File template, File translation, Locale translationLocale, Options options) {
        String cmd;
        if (!template.exists()) {
            options.getLog().trace("skipping PO updates; POT file did not exist : {0}", template);
            return;
        }
        if (translation.lastModified() >= template.lastModified()) {
            options.getLog().trace("skipping PO updates; up-to-date : {0}", translation);
            return;
        }
        if (translation.exists()) {
            cmd = "msgmerge --quiet --backup=none --update " + FileUtils.resolveFullPathName(translation) + " " + FileUtils.resolveFullPathName(template);
        } else {
            translation.getParentFile().mkdirs();
            cmd = "msginit --no-translator -l " + translationLocale + " -i " + FileUtils.resolveFullPathName(template) + " -o " + FileUtils.resolveFullPathName(translation);
        }
        Executor.execute(cmd);
    }
}

