/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.i18n.gettext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.Options;
import org.jboss.jdocbook.i18n.TranslationBuilder;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.I18nUtils;
import org.jboss.jdocbook.util.XIncludeHelper;
import org.jboss.maven.shared.process.Executor;

public class TranslationBuilderImpl
implements TranslationBuilder {
    public void buildTranslation(File masterFile, File poDirectory, File targetDirectory, Options options) throws JDocBookProcessException {
        options.getLog().trace("starting translation [" + masterFile + "]");
        if (!masterFile.exists()) {
            options.getLog().info("skipping translation; master file did not exist : {0}", masterFile);
            return;
        }
        String poFileName = I18nUtils.determinePoFileName(masterFile);
        File poFile = new File(poDirectory, poFileName);
        if (!poFile.exists()) {
            throw new JDocBookProcessException("Unable to locate PO file for [" + masterFile.getName() + "] in [" + poDirectory.getName() + "]");
        }
        File translatedFile = new File(targetDirectory, masterFile.getName());
        this.generateTranslatedXML(masterFile, poFile, translatedFile, options);
        File sourceBasedir = masterFile.getParentFile();
        for (File inclusion : XIncludeHelper.locateInclusions(masterFile)) {
            options.getLog().trace("starting translation of inclusion [" + inclusion + "]");
            String relativity = FileUtils.determineRelativity(inclusion, sourceBasedir);
            options.getLog().trace("determined relativity : " + relativity);
            File relativeTranslationDir = relativity == null ? poDirectory : new File(poDirectory, relativity);
            File relativeWorkDir = relativity == null ? targetDirectory : new File(targetDirectory, relativity);
            this.buildTranslation(inclusion, relativeTranslationDir, relativeWorkDir, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTranslatedXML(File masterFile, File poFile, File translatedFile, Options options) {
        if (!masterFile.exists()) {
            options.getLog().trace("skipping translation; source file did not exist : {0}", masterFile);
            return;
        }
        if (!poFile.exists()) {
            options.getLog().trace("skipping translation; PO file did not exist : {0}", poFile);
            return;
        }
        if (translatedFile.exists() && translatedFile.lastModified() >= masterFile.lastModified() && translatedFile.lastModified() >= poFile.lastModified()) {
            options.getLog().trace("skipping translation; up-to-date : {0}", translatedFile);
            return;
        }
        translatedFile.getParentFile().mkdirs();
        String cmd = "po2xml " + FileUtils.resolveFullPathName(masterFile) + " " + FileUtils.resolveFullPathName(poFile);
        try {
            FileOutputStream xmlStream = new FileOutputStream(translatedFile);
            try {
                options.getLog().trace("<execute>" + cmd + "</execution>");
                Executor.execute(cmd, xmlStream);
            }
            finally {
                try {
                    xmlStream.flush();
                    xmlStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException e) {
            throw new JDocBookProcessException("unable to open output stream for translated XML file [" + translatedFile + "]");
        }
    }
}

