/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.profile;

import java.io.File;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jdocbook.Options;
import org.jboss.jdocbook.profile.Profiler;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.xslt.XSLTException;
import org.xml.sax.EntityResolver;

class ProfilerImpl
implements Profiler {
    private final File outputDirectory;
    private final Options options;

    ProfilerImpl(File outputDirectory, Options options) {
        this.outputDirectory = outputDirectory;
        this.options = options;
    }

    public File applyProfiling(File sourceFile) {
        try {
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdirs();
            }
            File targetFile = new File(this.outputDirectory, sourceFile.getName());
            this.options.getLog().info("applying DocBook profiling [" + targetFile.getAbsolutePath() + "]");
            Transformer xslt = this.options.getTransformerBuilder().buildStandardTransformer("profiling/profile.xsl");
            xslt.transform(this.buildSource(sourceFile), this.buildResult(targetFile));
            return targetFile;
        }
        catch (TransformerException e) {
            throw new XSLTException("error performing translation [" + e.getLocationAsString() + "] : " + e.getMessage(), e);
        }
    }

    private Source buildSource(File sourceFile) throws RenderingException {
        return FileUtils.createSAXSource(sourceFile, (EntityResolver)this.options.getCatalogResolver(), this.options.isXincludeSupported());
    }

    protected Result buildResult(File targetFile) throws RenderingException, XSLTException {
        return new StreamResult(targetFile);
    }
}

