/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import javax.xml.transform.sax.SAXTransformerFactory;
import org.apache.xalan.processor.TransformerFactoryImpl;

public abstract class TransformerType {
    public static final TransformerType SAXON = new SaxonTransformerType();
    public static final TransformerType XALAN = new XalanTransformerType();
    private final String name;
    private SAXTransformerFactory factory;

    private TransformerType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public SAXTransformerFactory getSAXTransformerFactory() {
        if (this.factory == null) {
            this.factory = this.buildSAXTransformerFactory();
        }
        return this.factory;
    }

    protected abstract SAXTransformerFactory buildSAXTransformerFactory();

    public static TransformerType parse(String name) {
        if (TransformerType.XALAN.name.equals(name)) {
            return XALAN;
        }
        return SAXON;
    }

    public static class XalanTransformerType
    extends TransformerType {
        public XalanTransformerType() {
            super("xalan");
        }

        public SAXTransformerFactory buildSAXTransformerFactory() {
            return new TransformerFactoryImpl();
        }
    }

    public static class SaxonTransformerType
    extends TransformerType {
        public SaxonTransformerType() {
            super("saxon");
        }

        public SAXTransformerFactory buildSAXTransformerFactory() {
            return new com.icl.saxon.TransformerFactoryImpl();
        }
    }
}

