/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import com.icl.saxon.TransformerFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.NoOpWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XIncludeHelper {
    public static Set<File> locateInclusions(File root) {
        final TreeSet<File> includes = new TreeSet<File>();
        try {
            SAXParserFactoryImpl parserFactory = new SAXParserFactoryImpl();
            parserFactory.setXIncludeAware(true);
            EntityResolver resolver = new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (publicId == null && systemId != null && systemId.startsWith("file:/")) {
                        try {
                            includes.add(new File(new URL(systemId).getFile()));
                        }
                        catch (MalformedURLException e) {
                            throw new JDocBookProcessException("Unable to convert reported XInclude href into URL instance [" + systemId + "]");
                        }
                    }
                    return null;
                }
            };
            SAXSource transformationSource = FileUtils.createSAXSource(root, resolver, true);
            StreamResult transformationResult = new StreamResult(new NoOpWriter());
            TransformerFactoryImpl transformerFactory = new TransformerFactoryImpl();
            transformerFactory.newTransformer().transform(transformationSource, transformationResult);
        }
        catch (TransformerException e) {
            throw new JDocBookProcessException("Problem performing 'transformation'", e);
        }
        return includes;
    }
}

