/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;
import org.jboss.maven.shared.resource.ResourceDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMojo
extends AbstractDocBookMojo {
    @Override
    protected void process(FormatPlan[] formattings) throws RenderingException, XSLTException {
        this.processDependencySupportArtifacts(this.collectDocBookStyleDependentArtifacts());
        this.processProjectResources();
    }

    private void processProjectResources() throws RenderingException {
        if (this.imageResource != null) {
            new ResourceDelegate(this.project, new File(this.stagingDirectory, "images"), this.getLog()).process(this.imageResource);
        }
        if (this.cssResource != null) {
            new ResourceDelegate(this.project, new File(this.stagingDirectory, "css"), this.getLog()).process(this.cssResource);
        }
    }

    private List<Artifact> collectDocBookStyleDependentArtifacts() {
        final ArrayList<Artifact> rtn = new ArrayList<Artifact>();
        this.processArtifacts(new AbstractDocBookMojo.ArtifactProcessor(){

            public void process(Artifact artifact) {
                if ("jdocbook-style".equals(artifact.getType())) {
                    rtn.add(artifact);
                }
            }
        });
        return rtn;
    }

    private void processDependencySupportArtifacts(List<Artifact> artifacts) throws RenderingException {
        for (Artifact artifact : artifacts) {
            this.processDependencySupportArtifact(artifact.getFile(), this.stagingDirectory);
        }
    }

    protected void processDependencySupportArtifact(File file, File target) throws RenderingException {
        this.getLog().info((CharSequence)("unpacking dependency resource [" + file.getAbsolutePath() + "] to staging-dir [" + target.getAbsolutePath() + "]"));
        try {
            target.mkdirs();
            UnArchiver unArchiver = this.archiverManager.getUnArchiver("jar");
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(target);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new RenderingException("Unknown archiver type", e);
        }
        catch (ArchiverException e) {
            throw new RenderingException("Error unpacking file [" + file + "] to [" + target + "]", e);
        }
        catch (IOException e) {
            throw new RenderingException("Error unpacking file [" + file + "] to [" + target + "]", e);
        }
    }
}

