/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.shared.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamBridge
implements Runnable {
    private static final int DEF_BUFFER_SIZE = 512;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final int bufferSize;
    private boolean stopped = false;

    public StreamBridge(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, 512);
    }

    public StreamBridge(InputStream inputStream, OutputStream outputStream, int bufferSize) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] buf = new byte[this.bufferSize];
        try {
            int length;
            while ((length = this.inputStream.read(buf)) > 0 && !this.stopped) {
                this.outputStream.write(buf, 0, length);
                this.outputStream.flush();
            }
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            StreamBridge streamBridge = this;
            synchronized (streamBridge) {
                this.notifyAll();
            }
        }
        finally {
            StreamBridge streamBridge = this;
            synchronized (streamBridge) {
                this.notifyAll();
            }
        }
    }

    synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }
}

