/*
 * jDocBook, processing of DocBook sources as a Maven plugin
 *
 * Copyright (c) 2008, Red Hat Middleware LLC or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Middleware LLC.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 */
package org.jboss.jdocbook;

/**
 * A general 'log bridge' contract.
 *
 * @author Steve Ebersole
 */
public interface Log {
	public void trace(String message);
	public void trace(String message, Object... args);

	public void info(String message);
	public void info(String message, Object... args);
	public void info(String message, Throwable exception);
	public void info(String message, Throwable exception, Object... args);

	public void error(String message);
	public void error(String message, Object... args);
	public void error(String message, Throwable exception);
	public void error(String message, Throwable exception, Object... args);
}
