/*
 * jDocBook, processing of DocBook sources as a Maven plugin
 *
 * Copyright (c) 2008, Red Hat Middleware LLC or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Middleware LLC.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 *
 */
package org.jboss.maven.shared.process;

import java.io.OutputStream;

/**
 * ProcessOutputManager implementation
 *
 * @author Steve Ebersole
 */
public class ProcessOutputManager {
	private final StreamBridge outputBridge;
	private final StreamBridge errorBridge;

	private final Thread outputStreamThread;
	private final Thread errorStreamThread;

	public ProcessOutputManager(Process process, OutputStream out, OutputStream err) {
		outputBridge = new StreamBridge( process.getInputStream(), out );
		errorBridge = new StreamBridge( process.getErrorStream(), err );

		outputStreamThread = new Thread( outputBridge );
		outputStreamThread.setDaemon( true );
		outputStreamThread.start();

		errorStreamThread = new Thread( errorBridge );
		errorStreamThread.setDaemon( true );
		errorStreamThread.start();
	}

	public void stop() {
		try {
			outputStreamThread.join();
		}
		catch ( InterruptedException e ) {
			// ignore
		}
		try {
			errorStreamThread.join();
		}
		catch ( InterruptedException e ) {
			// ignore
		}
		outputBridge.stop();
		errorBridge.stop();
	}
}
