/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook;

import java.util.Properties;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.jboss.jdocbook.Log;
import org.jboss.jdocbook.util.TransformerType;
import org.jboss.jdocbook.xslt.TransformerBuilder;
import org.jboss.jdocbook.xslt.catalog.AbstractCatalogManager;
import org.jboss.jdocbook.xslt.catalog.ExplicitCatalogManager;
import org.jboss.jdocbook.xslt.catalog.ImplicitCatalogManager;

public class Options {
    private boolean xincludeSupported;
    private String[] catalogs;
    private String xmlTransformerType;
    private Properties transformerParameters;
    private boolean useRelativeImageUris = true;
    private String docbookVersion;
    private char localeSeparator = (char)45;
    private CatalogResolver catalogResolver;
    private TransformerBuilder transformerBuilder;
    private Log log = new NoOpLog();

    protected Options() {
    }

    public Options(char localeSeparator) {
        this.localeSeparator = localeSeparator;
    }

    public Options(boolean xincludeSupported, String[] catalogs, String xmlTransformerType, Properties transformerParameters, boolean useRelativeImageUris, String docBookVersion, char localeSeparator) {
        this.xincludeSupported = xincludeSupported;
        this.catalogs = catalogs;
        this.xmlTransformerType = xmlTransformerType;
        this.transformerParameters = transformerParameters;
        this.useRelativeImageUris = useRelativeImageUris;
        this.docbookVersion = docBookVersion;
        this.localeSeparator = localeSeparator;
    }

    public boolean isXincludeSupported() {
        return this.xincludeSupported;
    }

    public String[] getCatalogs() {
        return this.catalogs;
    }

    public String getXmlTransformerType() {
        return this.xmlTransformerType;
    }

    public TransformerType resolveXmlTransformerType() {
        return TransformerType.parse(this.getXmlTransformerType());
    }

    public Properties getTransformerParameters() {
        if (this.transformerParameters == null) {
            this.transformerParameters = new Properties();
        }
        return this.transformerParameters;
    }

    public boolean isUseRelativeImageUris() {
        return this.useRelativeImageUris;
    }

    public String getDocbookVersion() {
        return this.docbookVersion;
    }

    public void setDocbookVersion(String docbookVersion) {
        this.docbookVersion = docbookVersion;
    }

    public char getLocaleSeparator() {
        return this.localeSeparator;
    }

    public CatalogResolver getCatalogResolver() {
        if (this.catalogResolver == null) {
            AbstractCatalogManager catalogManager = this.getCatalogs() == null || this.getCatalogs().length == 0 ? new ImplicitCatalogManager() : new ExplicitCatalogManager(this.getCatalogs());
            this.catalogResolver = new CatalogResolver((CatalogManager)catalogManager);
        }
        return this.catalogResolver;
    }

    public TransformerBuilder getTransformerBuilder() {
        if (this.transformerBuilder == null) {
            this.transformerBuilder = new TransformerBuilder(this);
        }
        return this.transformerBuilder;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    private static class NoOpLog
    implements Log {
        private NoOpLog() {
        }

        public void trace(String message) {
        }

        public void trace(String message, Object[] args) {
        }

        public void info(String message) {
        }

        public void info(String message, Object[] args) {
        }

        public void info(String message, Throwable exception) {
        }

        public void info(String message, Throwable exception, Object[] args) {
        }

        public void error(String message) {
        }

        public void error(String message, Object[] args) {
        }

        public void error(String message, Throwable exception) {
        }

        public void error(String message, Throwable exception, Object[] args) {
        }
    }
}

