/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.i18n.gettext;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.Options;
import org.jboss.jdocbook.i18n.PotSynchronizer;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.I18nUtils;
import org.jboss.jdocbook.util.XIncludeHelper;
import org.jboss.maven.shared.process.Executor;

public class PotSynchronizerImpl
implements PotSynchronizer {
    public void synchronizePot(File masterFile, File templateDirectory, Options options) throws JDocBookProcessException {
        if (!masterFile.exists()) {
            options.getLog().info("skipping POT updates; master file did not exist : {0}", new Object[]{masterFile});
            return;
        }
        File sourceBasedir = masterFile.getParentFile();
        String potFileName = I18nUtils.determinePotFileName(masterFile);
        File potFile = new File(templateDirectory, potFileName);
        this.updatePortableObjectTemplate(masterFile, potFile, options);
        Iterator i = XIncludeHelper.locateInclusions(masterFile).iterator();
        while (i.hasNext()) {
            File inclusion = (File)i.next();
            String relativity = FileUtils.determineRelativity(inclusion, sourceBasedir);
            File relativeTemplateDir = relativity == null ? templateDirectory : new File(templateDirectory, relativity);
            this.synchronizePot(inclusion, relativeTemplateDir, options);
        }
    }

    private void updatePortableObjectTemplate(File masterFile, File potFile, Options options) {
        if (!masterFile.exists()) {
            options.getLog().trace("skipping POT update; source file did not exist : {0}", new Object[]{masterFile});
            return;
        }
        if (potFile.exists() && potFile.lastModified() >= masterFile.lastModified()) {
            options.getLog().trace("skipping POT update; up-to-date : {0}", new Object[]{potFile});
            return;
        }
        potFile.getParentFile().mkdirs();
        this.executeXml2pot(masterFile, potFile, options);
    }

    private void executeXml2pot(File masterFile, File potFile, Options options) {
        String cmd = "xml2pot " + FileUtils.resolveFullPathName(masterFile);
        try {
            FileOutputStream xmlStream = new FileOutputStream(potFile);
            try {
                options.getLog().trace("updating POT file {0}", new Object[]{potFile});
                Executor.execute(cmd, xmlStream);
            }
            finally {
                try {
                    xmlStream.flush();
                    xmlStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            throw new JDocBookProcessException("unable to open output stream for POT file [" + potFile + "]");
        }
    }
}

