/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jdocbook.Options;
import org.jboss.jdocbook.render.Renderer;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.ResourceHelper;
import org.jboss.jdocbook.xslt.XSLTException;
import org.xml.sax.EntityResolver;

public class BasicRenderer
implements Renderer {
    protected final Options options;

    public BasicRenderer(Options options) {
        this.options = options;
    }

    public File getAttachableBundle(File source) {
        return null;
    }

    public void render(File sourceFile, FormatPlan formatPlan, File renderingDirectory, File stagingDirectory) throws RenderingException, XSLTException {
        File targetFile;
        File targetDirectory = new File(renderingDirectory, formatPlan.getName());
        if (!targetDirectory.exists()) {
            FileUtils.mkdir((String)targetDirectory.getAbsolutePath());
        }
        if (formatPlan.isImageCopyingRequired() && stagingDirectory.exists()) {
            File cssBase;
            File imageBase = new File(stagingDirectory, "images");
            if (imageBase.exists()) {
                try {
                    FileUtils.copyDirectoryStructure((File)imageBase, (File)targetDirectory);
                }
                catch (IOException e) {
                    throw new RenderingException("unable to copy images", e);
                }
            }
            if ((cssBase = new File(stagingDirectory, "css")).exists()) {
                try {
                    FileUtils.copyDirectoryStructure((File)cssBase, (File)targetDirectory);
                }
                catch (IOException e) {
                    throw new RenderingException("unable to copy css", e);
                }
            }
        }
        if ((targetFile = new File(targetDirectory, this.deduceTargetFileName(sourceFile, formatPlan))).exists()) {
            targetFile.delete();
        }
        if (!targetFile.exists()) {
            try {
                targetFile.createNewFile();
            }
            catch (IOException e) {
                throw new RenderingException("unable to create output file [" + targetFile.getAbsolutePath() + "]", e);
            }
        }
        this.performRendering(sourceFile, formatPlan, stagingDirectory, targetFile);
    }

    private void performRendering(File sourceFile, FormatPlan formatPlan, File stagingDirectory, File targetFile) {
        Transformer transformer = this.buildTransformer(targetFile, formatPlan, stagingDirectory);
        Source transformationSource = this.buildSource(sourceFile);
        Result transformationResult = this.buildResult(targetFile);
        try {
            try {
                transformer.transform(transformationSource, transformationResult);
            }
            catch (TransformerException e) {
                throw new XSLTException("error performing translation [" + e.getMessageAndLocation() + "]", e);
            }
        }
        finally {
            this.releaseResult(transformationResult);
        }
    }

    private String deduceTargetFileName(File source, FormatPlan formatPlan) {
        return formatPlan.getTargetNamingStrategy().determineTargetFileName(source);
    }

    protected Transformer buildTransformer(File targetFile, FormatPlan formatPlan, File stagingDirectory) throws RenderingException, XSLTException {
        URL transformationStylesheet = ResourceHelper.requireResource(formatPlan.getStylesheetResource());
        Transformer transformer = this.options.getTransformerBuilder().buildTransformer(formatPlan, transformationStylesheet);
        if (formatPlan.isImagePathSettingRequired()) {
            try {
                String imgSrcPath = new File(stagingDirectory, "images").toURL().toString();
                if (!imgSrcPath.endsWith("/")) {
                    imgSrcPath = String.valueOf(imgSrcPath) + '/';
                }
                this.options.getLog().trace("setting 'img.src.path' xslt parameter [" + imgSrcPath + "]");
                transformer.setParameter("img.src.path", imgSrcPath);
            }
            catch (MalformedURLException e) {
                throw new XSLTException("unable to prepare 'img.src.path' xslt parameter", e);
            }
        }
        transformer.setParameter("keep.relative.image.uris", this.options.isUseRelativeImageUris() ? "1" : "0");
        if (formatPlan.isDoingChunking()) {
            String rootFilename = targetFile.getName();
            rootFilename = rootFilename.substring(0, rootFilename.lastIndexOf(46));
            transformer.setParameter("root.filename", rootFilename);
            transformer.setParameter("base.dir", String.valueOf(targetFile.getParent()) + File.separator);
            transformer.setParameter("manifest.in.base.dir", "1");
        }
        return transformer;
    }

    private Source buildSource(File sourceFile) throws RenderingException {
        return FileUtils.createSAXSource(sourceFile, (EntityResolver)this.options.getCatalogResolver(), this.options.isXincludeSupported());
    }

    protected Result buildResult(File targetFile) throws RenderingException, XSLTException {
        return new StreamResult(targetFile);
    }

    protected void releaseResult(Result transformationResult) {
    }
}

