/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.jboss.jdocbook.Options;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.impl.BasicRenderer;

public class PDFRenderer
extends BasicRenderer {
    public PDFRenderer(Options options) {
        super(options);
    }

    protected Result buildResult(File targetFile) throws RenderingException {
        return new ResultImpl(targetFile);
    }

    protected void releaseResult(Result transformationResult) {
        ((ResultImpl)transformationResult).release();
    }

    private class ResultImpl
    extends SAXResult {
        private OutputStream outputStream;

        public ResultImpl(File targetFile) throws RenderingException {
            try {
                FopFactory fopFactory = FopFactory.newInstance();
                this.outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
                FOUserAgent fopUserAgent = fopFactory.newFOUserAgent();
                fopUserAgent.setProducer("jDocBook Plugin for Maven");
                Fop fop = fopFactory.newFop("application/pdf", fopUserAgent, this.outputStream);
                this.setHandler(fop.getDefaultHandler());
            }
            catch (Throwable t) {
                throw new RenderingException("error building transformation result [" + targetFile.getAbsolutePath() + "]", t);
            }
        }

        private void release() {
            if (this.outputStream == null) {
                return;
            }
            try {
                this.outputStream.flush();
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

