/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import java.net.MalformedURLException;
import java.net.URL;

public class ResourceHelper {
    static /* synthetic */ Class class$0;

    public static URL requireResource(String name) {
        URL resource = ResourceHelper.locateResource(name);
        if (resource == null) {
            throw new IllegalArgumentException("could not locate resource [" + name + "]");
        }
        return resource;
    }

    public static URL locateResource(String name) {
        if (name.startsWith("classpath:")) {
            return ResourceHelper.locateClassPathResource(name.substring(10));
        }
        if (name.startsWith("file:")) {
            try {
                return new URL(name);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("malformed explicit file url [" + name + "]");
            }
        }
        return ResourceHelper.locateClassPathResource(name);
    }

    private static URL locateClassPathResource(String name) {
        URL result;
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.jboss.jdocbook.util.ResourceHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            loader = clazz.getClassLoader();
        }
        if ((result = loader.getResource(name)) == null) {
            result = loader.getResource("/" + name);
        }
        return result;
    }
}

