/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt;

import com.icl.saxon.Controller;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jdocbook.Options;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.util.NoOpWriter;
import org.jboss.jdocbook.util.ResourceHelper;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.jdocbook.xslt.resolve.ClasspathResolver;
import org.jboss.jdocbook.xslt.resolve.CurrentVersionResolver;
import org.jboss.jdocbook.xslt.resolve.ExplicitUrnResolver;
import org.jboss.jdocbook.xslt.resolve.RelativeJarUriResolver;
import org.jboss.jdocbook.xslt.resolve.ResolverChain;
import org.jboss.jdocbook.xslt.resolve.VersionResolver;

public class TransformerBuilder {
    private final Options options;

    public TransformerBuilder(Options options) {
        this.options = options;
    }

    public Transformer buildStandardTransformer(URL xslt) {
        ResolverChain uriResolver = this.buildStandardUriResolver();
        return this.buildTransformer(xslt, uriResolver);
    }

    public Transformer buildStandardTransformer(String xsltResource) {
        ResolverChain uriResolver = this.buildStandardUriResolver();
        return this.buildTransformer(ResourceHelper.requireResource(xsltResource), uriResolver);
    }

    public Transformer buildTransformer(FormatPlan formatPlan, URL customStylesheet) throws XSLTException {
        ResolverChain uriResolver = this.buildUriResolver(formatPlan);
        URL xsltStylesheet = customStylesheet == null ? ResourceHelper.requireResource(formatPlan.getStylesheetResource()) : customStylesheet;
        return this.buildTransformer(xsltStylesheet, uriResolver);
    }

    protected Transformer buildTransformer(URL xslt, URIResolver uriResolver) throws XSLTException {
        Transformer transformer;
        SAXTransformerFactory transformerFactory = this.options.resolveXmlTransformerType().getSAXTransformerFactory();
        transformerFactory.setURIResolver(uriResolver);
        try {
            StreamSource source = new StreamSource(xslt.openStream(), xslt.toExternalForm());
            transformer = transformerFactory.newTransformer(source);
        }
        catch (IOException e) {
            throw new XSLTException("problem opening stylesheet", e);
        }
        catch (TransformerConfigurationException e) {
            throw new XSLTException("unable to build transformer [" + e.getLocationAsString() + "] : " + e.getMessage(), e);
        }
        TransformerBuilder.configureTransformer(transformer, uriResolver, this.options.getTransformerParameters());
        return transformer;
    }

    public void configureTransformer(Transformer transformer, FormatPlan formatPlan) {
        TransformerBuilder.configureTransformer(transformer, this.buildUriResolver(formatPlan), this.options.getTransformerParameters());
    }

    public static void configureTransformer(Transformer transformer, URIResolver uriResolver, Properties transformerParameters) {
        if (transformer instanceof Controller) {
            Controller controller = (Controller)transformer;
            try {
                controller.makeMessageEmitter();
                controller.getMessageEmitter().setWriter((Writer)new NoOpWriter());
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
        }
        transformer.setURIResolver(uriResolver);
        transformer.setParameter("fop.extensions", "0");
        transformer.setParameter("fop1.extensions", "1");
        if (transformerParameters == null) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> i = transformerParameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            transformer.setParameter((String)entry.getKey(), entry.getValue());
        }
    }

    public ResolverChain buildStandardUriResolver() {
        ResolverChain resolverChain = new ResolverChain();
        this.applyStandardResolvers(resolverChain);
        return resolverChain;
    }

    public ResolverChain buildUriResolver(FormatPlan formatPlan) throws XSLTException {
        return this.buildUriResolver(formatPlan.getName(), formatPlan.getCorrespondingDocBookStylesheetResource());
    }

    public ResolverChain buildUriResolver(String formatName, String docBookstyleSheet) throws XSLTException {
        ResolverChain resolverChain = new ResolverChain(new ExplicitUrnResolver(formatName, docBookstyleSheet));
        this.applyStandardResolvers(resolverChain);
        return resolverChain;
    }

    private void applyStandardResolvers(ResolverChain resolverChain) {
        resolverChain.addResolver(new CurrentVersionResolver());
        if (this.options.getDocbookVersion() != null) {
            resolverChain.addResolver(new VersionResolver(this.options.getDocbookVersion()));
        }
        resolverChain.addResolver(new RelativeJarUriResolver());
        resolverChain.addResolver(new ClasspathResolver());
        resolverChain.addResolver((URIResolver)this.options.getCatalogResolver());
    }
}

