/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt.resolve;

import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class ClasspathResolver
implements URIResolver {
    private final ClassLoader classLoader;

    public ClasspathResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClasspathResolver() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (!href.startsWith("classpath:")) {
            return null;
        }
        try {
            URL url = this.classLoader.getResource(href.substring(10));
            return new StreamSource(url.openStream(), url.toExternalForm());
        }
        catch (Throwable t) {
            return null;
        }
    }
}

