/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt.resolve;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jdocbook.util.ResourceHelper;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.jdocbook.xslt.resolve.BasicUrnResolver;

public class ExplicitUrnResolver
extends BasicUrnResolver {
    private final String name;

    public ExplicitUrnResolver(String name, String stylesheetResource) throws XSLTException {
        super("urn:docbook:stylesheet", ExplicitUrnResolver.createSource(name, stylesheetResource));
        this.name = name;
    }

    private static Source createSource(String name, String stylesheetResource) throws XSLTException {
        URL stylesheet = ResourceHelper.requireResource(stylesheetResource);
        try {
            return new StreamSource(stylesheet.openStream(), stylesheet.toExternalForm());
        }
        catch (IOException e) {
            throw new XSLTException("could not locate DocBook stylesheet [" + name + "]", e);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [" + this.name + "]";
    }
}

