/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt.resolve;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jdocbook.util.ResourceHelper;

public class VersionResolver
implements URIResolver {
    public static final String BASE_HREF = "http://docbook.sourceforge.net/release/xsl/";
    private final String version;
    private final String versionHref;

    public VersionResolver(String version) {
        this.version = version;
        this.versionHref = BASE_HREF + version;
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (href.startsWith(this.versionHref)) {
            return this.resolve(href);
        }
        if (base.startsWith(this.versionHref)) {
            return this.resolve(String.valueOf(base) + "/" + href);
        }
        return null;
    }

    private Source resolve(String href) {
        String resource = href.substring(this.versionHref.length());
        try {
            URL resourceURL = ResourceHelper.requireResource(resource);
            return new StreamSource(resourceURL.openStream(), resourceURL.toExternalForm());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [version=" + this.version + "]";
    }
}

