/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.Log;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.render.format.StandardDocBookFormatDescriptors;
import org.jboss.jdocbook.util.LocaleUtils;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.maven.plugins.jdocbook.Format;
import org.jboss.maven.plugins.jdocbook.Options;

public abstract class AbstractDocBookMojo
extends AbstractMojo {
    public static final String PLUGIN_NAME = "jdocbook";
    protected MavenProject project;
    protected MavenSession session;
    protected Set projectArtifacts;
    protected List pluginArtifacts;
    protected ArchiverManager archiverManager;
    protected MavenProjectHelper projectHelper;
    protected String sourceDocumentName;
    protected File sourceDirectory;
    protected Resource imageResource;
    protected Resource cssResource;
    protected File fontsDirectory;
    protected File publishDirectory;
    protected File stagingDirectory;
    protected File workDirectory;
    protected Format[] formats;
    protected boolean attach = true;
    protected Options options;
    protected String masterTranslation;
    protected String relativeMasterTranslationPath;
    protected File potDirectory;
    protected String[] translations;
    protected File translationBaseDirectory;
    private File resolvedMasterSourceDirectory;

    protected void process(FormatPlan[] formatPlans) throws JDocBookProcessException {
    }

    protected void doExecute() throws JDocBookProcessException {
        this.process(this.determineFormatPlans());
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        File test;
        if (this.options == null) {
            this.options = new Options();
        }
        this.options.setLog(new MavenLogBridge());
        if (this.translationBaseDirectory == null) {
            this.translationBaseDirectory = this.sourceDirectory;
        }
        if (this.translations == null) {
            this.translations = new String[0];
        }
        if ((this.relativeMasterTranslationPath == null || "".equals(this.relativeMasterTranslationPath)) && (test = new File(this.sourceDirectory, this.masterTranslation)).exists()) {
            this.relativeMasterTranslationPath = this.masterTranslation;
        }
        this.resolvedMasterSourceDirectory = this.sourceDirectory;
        if (this.relativeMasterTranslationPath != null && !"".equals(this.relativeMasterTranslationPath)) {
            this.resolvedMasterSourceDirectory = new File(this.resolvedMasterSourceDirectory, this.relativeMasterTranslationPath);
        }
        try {
            this.doExecute();
        }
        catch (XSLTException e) {
            throw new MojoExecutionException("XSLT problem", (Exception)e);
        }
        catch (RenderingException e) {
            throw new MojoExecutionException("Rendering problem", (Exception)e);
        }
    }

    private FormatPlan[] determineFormatPlans() {
        FormatPlan[] plans = new FormatPlan[this.formats.length];
        int i = 0;
        while (i < this.formats.length) {
            plans[i] = new FormatPlan(this.formats[i], StandardDocBookFormatDescriptors.getDescriptor(this.formats[i].getFormatName()));
            ++i;
        }
        return plans;
    }

    protected String getRequestedFormat() {
        String requestedFormat = this.session.getExecutionProperties().getProperty("jdocbook.format");
        if (requestedFormat != null) {
            this.getLog().info((CharSequence)("requested processing limited to [" + requestedFormat + "] format"));
        }
        return requestedFormat;
    }

    protected Locale getRequestedLocale() {
        Locale requestedLocale;
        String requestedLocaleStr = this.session.getExecutionProperties().getProperty("jdocbook.lang");
        Locale locale = requestedLocale = requestedLocaleStr == null ? null : this.parseLocale(requestedLocaleStr);
        if (requestedLocale != null) {
            this.getLog().info((CharSequence)("requested processing limited to [" + this.stringify(requestedLocale) + "] lang"));
        }
        return requestedLocale;
    }

    protected MasterTranslationDescriptor getMasterTranslationDescriptor() {
        return new MasterTranslationDescriptor(this.parseLocale(this.masterTranslation));
    }

    protected List getPublishingSources() {
        ArrayList<PublishingSource> descriptors = new ArrayList<PublishingSource>();
        descriptors.add(this.getMasterTranslationDescriptor());
        int i = 0;
        while (i < this.translations.length) {
            String locale = this.translations[i];
            descriptors.add(new TranslationDescriptor(this.parseLocale(locale)));
            ++i;
        }
        return descriptors;
    }

    protected List getI18nSources() {
        ArrayList<TranslationDescriptor> descriptors = new ArrayList<TranslationDescriptor>();
        int i = 0;
        while (i < this.translations.length) {
            String locale = this.translations[i];
            descriptors.add(new TranslationDescriptor(this.parseLocale(locale)));
            ++i;
        }
        return descriptors;
    }

    protected void processArtifacts(ArtifactProcessor processor) {
        this.processProjectArtifacts(processor);
        this.processPluginArtifacts(processor);
    }

    protected void processProjectArtifacts(ArtifactProcessor processor) {
        this.processArtifacts(processor, this.projectArtifacts);
    }

    protected void processPluginArtifacts(ArtifactProcessor processor) {
        this.processArtifacts(processor, this.pluginArtifacts);
    }

    private void processArtifacts(ArtifactProcessor processor, Collection artifacts) {
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            processor.process(artifact);
        }
    }

    protected Locale parseLocale(String locale) {
        return LocaleUtils.parse(locale, this.options.getLocaleSeparator());
    }

    protected String stringify(Locale locale) {
        return LocaleUtils.render(locale, this.options.getLocaleSeparator());
    }

    protected static interface ArtifactProcessor {
        public void process(Artifact var1);
    }

    protected static interface I18nSource {
        public Locale getLocale();

        public File resolvePoDirectory();

        public File resolveTranslatedXmlDirectory();
    }

    protected class MasterTranslationDescriptor
    implements PublishingSource {
        private final Locale locale;

        public MasterTranslationDescriptor(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public File resolveDocumentFile() {
            return new File(AbstractDocBookMojo.this.resolvedMasterSourceDirectory, AbstractDocBookMojo.this.sourceDocumentName);
        }

        public File resolvePublishingDirectory() {
            return new File(AbstractDocBookMojo.this.publishDirectory, AbstractDocBookMojo.this.stringify(this.locale));
        }
    }

    private class MavenLogBridge
    implements Log {
        private MavenLogBridge() {
        }

        public void trace(String message) {
            AbstractDocBookMojo.this.getLog().debug((CharSequence)message);
        }

        public void trace(String message, Object[] args) {
            if (AbstractDocBookMojo.this.getLog().isDebugEnabled()) {
                AbstractDocBookMojo.this.getLog().debug((CharSequence)MessageFormat.format(message, args));
            }
        }

        public void info(String message) {
            AbstractDocBookMojo.this.getLog().info((CharSequence)message);
        }

        public void info(String message, Object[] args) {
            if (AbstractDocBookMojo.this.getLog().isInfoEnabled()) {
                AbstractDocBookMojo.this.getLog().info((CharSequence)MessageFormat.format(message, args));
            }
        }

        public void info(String message, Throwable exception) {
            AbstractDocBookMojo.this.getLog().info((CharSequence)message, exception);
        }

        public void info(String message, Throwable exception, Object[] args) {
            if (AbstractDocBookMojo.this.getLog().isInfoEnabled()) {
                AbstractDocBookMojo.this.getLog().info((CharSequence)MessageFormat.format(message, args), exception);
            }
        }

        public void error(String message) {
            AbstractDocBookMojo.this.getLog().error((CharSequence)message);
        }

        public void error(String message, Object[] args) {
            if (AbstractDocBookMojo.this.getLog().isErrorEnabled()) {
                AbstractDocBookMojo.this.getLog().error((CharSequence)MessageFormat.format(message, args));
            }
        }

        public void error(String message, Throwable exception) {
            AbstractDocBookMojo.this.getLog().error((CharSequence)message, exception);
        }

        public void error(String message, Throwable exception, Object[] args) {
            if (AbstractDocBookMojo.this.getLog().isErrorEnabled()) {
                AbstractDocBookMojo.this.getLog().error((CharSequence)MessageFormat.format(message, args), exception);
            }
        }
    }

    protected static interface PublishingSource {
        public Locale getLocale();

        public File resolveDocumentFile();

        public File resolvePublishingDirectory();
    }

    protected class TranslationDescriptor
    implements PublishingSource,
    I18nSource {
        private final Locale locale;

        public TranslationDescriptor(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public File resolvePoDirectory() {
            return new File(AbstractDocBookMojo.this.translationBaseDirectory, AbstractDocBookMojo.this.stringify(this.locale));
        }

        public File resolveTranslatedXmlDirectory() {
            return new File(new File(AbstractDocBookMojo.this.workDirectory, "xml"), AbstractDocBookMojo.this.stringify(this.locale));
        }

        public File resolveDocumentFile() {
            return new File(this.resolveTranslatedXmlDirectory(), AbstractDocBookMojo.this.sourceDocumentName);
        }

        public File resolvePublishingDirectory() {
            return new File(AbstractDocBookMojo.this.publishDirectory, AbstractDocBookMojo.this.stringify(this.locale));
        }
    }
}

