/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.Artifact;
import org.jboss.jdocbook.profile.ProfilerFactory;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.render.impl.RendererFactory;
import org.jboss.jdocbook.util.DocBookProfilingStrategy;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.maven.plugins.jdocbook.AbstractDocBookMojo;

public class GenerationMojo
extends AbstractDocBookMojo {
    protected void process(FormatPlan[] plans) throws XSLTException, RenderingException {
        if (!this.sourceDirectory.exists()) {
            this.getLog().info((CharSequence)("sourceDirectory [" + this.sourceDirectory.getAbsolutePath() + "] did not exist"));
            return;
        }
        if (!this.workDirectory.exists()) {
            this.workDirectory.mkdirs();
        }
        if (this.options.getDocbookVersion() == null) {
            this.processArtifacts(new AbstractDocBookMojo.ArtifactProcessor(){

                public void process(Artifact artifact) {
                    if ("net.sf.docbook".equals(artifact.getGroupId()) && "docbook".equals(artifact.getArtifactId())) {
                        GenerationMojo.this.getLog().debug((CharSequence)("Found docbook version : " + artifact.getVersion()));
                        if (GenerationMojo.this.options.getDocbookVersion() != null) {
                            GenerationMojo.this.getLog().warn((CharSequence)"found multiple docbook versions");
                        }
                        GenerationMojo.this.options.setDocbookVersion(artifact.getVersion());
                    }
                }
            });
        }
        RendererFactory rendererFactory = new RendererFactory(this.options);
        Locale requestedLocale = this.getRequestedLocale();
        String requestedFormat = this.getRequestedFormat();
        List sources = this.getPublishingSources();
        Iterator i = sources.iterator();
        while (i.hasNext()) {
            AbstractDocBookMojo.PublishingSource source = (AbstractDocBookMojo.PublishingSource)i.next();
            if (requestedLocale != null && !requestedLocale.equals(source.getLocale())) {
                this.getLog().info((CharSequence)("skipping non-requested lang [" + this.stringify(source.getLocale()) + "]"));
                continue;
            }
            File sourceFile = source.resolveDocumentFile();
            if (!sourceFile.exists()) {
                this.getLog().info((CharSequence)("Source document [" + sourceFile.getAbsolutePath() + "] did not exist; skipping"));
                continue;
            }
            File publishingDirectory = source.resolvePublishingDirectory();
            if (!publishingDirectory.exists()) {
                publishingDirectory.mkdirs();
            }
            String lang = this.stringify(source.getLocale());
            this.options.getTransformerParameters().setProperty("l10n.gentext.language", lang);
            this.options.getTransformerParameters().setProperty("profile.lang", lang);
            boolean hasBeenProfiled = false;
            int p = 0;
            while (p < plans.length) {
                FormatPlan plan = plans[p];
                if (requestedFormat != null && !requestedFormat.equals(plan.getName())) {
                    this.getLog().info((CharSequence)("skipping non-requested format [" + plan.getName() + "]"));
                } else {
                    if (plan.getProfiling() == DocBookProfilingStrategy.TWO_PASS && !hasBeenProfiled) {
                        hasBeenProfiled = true;
                        File profileOutputDir = new File(new File(this.workDirectory, "profile"), lang);
                        sourceFile = new ProfilerFactory(profileOutputDir, this.options).buildProfiler().applyProfiling(sourceFile);
                    }
                    rendererFactory.buildRenderer(plan.getName()).render(sourceFile, plan, publishingDirectory, this.stagingDirectory);
                }
                ++p;
            }
        }
    }
}

