/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.shared.process;

import java.io.IOException;
import java.io.OutputStream;
import org.jboss.maven.shared.process.ExecutionException;
import org.jboss.maven.shared.process.ProcessOutputManager;

public class Executor {
    public static void execute(String cmd) {
        Executor.execute(cmd, System.out, System.err);
    }

    public static void execute(String cmd, OutputStream out) {
        Executor.execute(cmd, out, System.err);
    }

    public static void execute(String cmd, OutputStream out, OutputStream err) {
        ProcessOutputManager outputManager = null;
        try {
            try {
                Process cmdProcess = Runtime.getRuntime().exec(cmd);
                outputManager = new ProcessOutputManager(cmdProcess, out, err);
                try {
                    cmdProcess.waitFor();
                }
                catch (InterruptedException e) {
                    throw new ExecutionException("unable to obtain appropriate runtime environment", e);
                }
                if (cmdProcess.exitValue() != 0) {
                    throw new ExecutionException("there was a problem executing command; check output");
                }
            }
            catch (IOException e) {
                throw new ExecutionException("unable to obtain appropriate runtime environment", e);
            }
        }
        finally {
            if (outputManager != null) {
                outputManager.stop();
            }
        }
    }
}

