/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.shared.process;

import java.io.OutputStream;
import org.jboss.maven.shared.process.StreamBridge;

public class ProcessOutputManager {
    private final StreamBridge outputBridge;
    private final StreamBridge errorBridge;
    private final Thread outputStreamThread;
    private final Thread errorStreamThread;

    public ProcessOutputManager(Process process, OutputStream out, OutputStream err) {
        this.outputBridge = new StreamBridge(process.getInputStream(), out);
        this.errorBridge = new StreamBridge(process.getErrorStream(), err);
        this.outputStreamThread = new Thread(this.outputBridge);
        this.outputStreamThread.setDaemon(true);
        this.outputStreamThread.start();
        this.errorStreamThread = new Thread(this.errorBridge);
        this.errorStreamThread.setDaemon(true);
        this.errorStreamThread.start();
    }

    public void stop() {
        try {
            this.outputStreamThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.errorStreamThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.outputBridge.stop();
        this.errorBridge.stop();
    }
}

