/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.i18n.gettext;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.Log;
import org.jboss.jdocbook.i18n.I18nEnvironment;
import org.jboss.jdocbook.i18n.I18nSource;
import org.jboss.jdocbook.i18n.PoSynchronizer;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.I18nUtils;
import org.jboss.jdocbook.util.LocaleUtils;
import org.jboss.jdocbook.util.VCSDirectoryExclusionFilter;

public class PoSynchronizerImpl
implements PoSynchronizer {
    private final I18nEnvironment environment;

    public PoSynchronizerImpl(I18nEnvironment environment) {
        this.environment = environment;
    }

    private Log getLog() {
        return this.environment.log();
    }

    public void synchronizePoFiles() {
        for (I18nSource source : this.environment.getI18nSources(true)) {
            this.synchronizePo(this.environment.getMasterTranslationDescriptor().resolvePotDirectory(), source.resolvePoDirectory(), source.getLocale());
        }
    }

    private void synchronizePo(File potDirectory, File poDirectory, Locale translationLocale) throws JDocBookProcessException {
        if (!potDirectory.exists()) {
            this.getLog().info("skipping PO updates; POT directory did not exist : {0}", potDirectory);
            return;
        }
        File[] files = potDirectory.listFiles(new VCSDirectoryExclusionFilter());
        int X = files.length;
        for (int i = 0; i < X; ++i) {
            if (files[i].isDirectory()) {
                this.synchronizePo(new File(potDirectory, files[i].getName()), new File(poDirectory, files[i].getName()), translationLocale);
                continue;
            }
            if (!I18nUtils.isPotFile(files[i])) continue;
            File translation = new File(poDirectory, I18nUtils.determinePoFileName(files[i]));
            this.updateTranslation(files[i], translation, translationLocale);
        }
    }

    private void updateTranslation(File template, File translation, Locale translationLocale) {
        CommandLine commandLine;
        if (!template.exists()) {
            this.getLog().trace("skipping PO updates; POT file did not exist : {0}", template);
            return;
        }
        if (translation.lastModified() >= template.lastModified()) {
            this.getLog().trace("skipping PO updates; up-to-date : {0}", translation);
            return;
        }
        String translationLocaleString = LocaleUtils.render(translationLocale, this.environment.getOptions().getLocaleSeparator());
        if (translation.exists()) {
            commandLine = CommandLine.parse((String)"msgmerge");
            commandLine.addArgument("--quiet");
            commandLine.addArgument("--update");
            commandLine.addArgument("--backup=none");
            commandLine.addArgument(FileUtils.resolveFullPathName(translation));
            commandLine.addArgument(FileUtils.resolveFullPathName(template));
        } else {
            boolean created;
            if (!translation.getParentFile().exists() && !(created = translation.getParentFile().mkdirs())) {
                this.getLog().info("Unable to create PO directory {}", translation.getParentFile().getAbsolutePath());
            }
            commandLine = CommandLine.parse((String)"msginit");
            commandLine.addArgument("--no-translator");
            commandLine.addArgument("--locale=" + translationLocaleString);
            commandLine.addArgument("-i");
            commandLine.addArgument(FileUtils.resolveFullPathName(template));
            commandLine.addArgument("-o");
            commandLine.addArgument(FileUtils.resolveFullPathName(translation));
        }
        this.getLog().info("po-synch -> " + commandLine.toString());
        DefaultExecutor executor = new DefaultExecutor();
        try {
            executor.execute(commandLine);
        }
        catch (IOException e) {
            throw new JDocBookProcessException("Error synchronizing PO file [" + template.getName() + "] for " + translationLocaleString, e);
        }
    }
}

