/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render;

import org.jboss.jdocbook.render.Renderer;
import org.jboss.jdocbook.render.RenderingEnvironment;
import org.jboss.jdocbook.render.format.FormatPlan;
import org.jboss.jdocbook.render.format.StandardDocBookFormatDescriptors;
import org.jboss.jdocbook.render.impl.BasicRenderer;
import org.jboss.jdocbook.render.impl.PDFRenderer;
import org.jboss.jdocbook.render.impl.XslFoGenerator;
import org.xml.sax.EntityResolver;

public class RendererFactory {
    private final RenderingEnvironment environment;

    public RendererFactory(RenderingEnvironment environment) {
        this.environment = environment;
    }

    public Renderer buildRenderer(FormatPlan formatPlan, EntityResolver entityResolver) {
        if (formatPlan.getName().equals(StandardDocBookFormatDescriptors.PDF.getName())) {
            return new PDFRenderer(this.environment, entityResolver, formatPlan);
        }
        return new BasicRenderer(this.environment, entityResolver, formatPlan);
    }

    public XslFoGenerator buildXslFoGenerator(FormatPlan formatPlan, EntityResolver entityResolver) {
        return new PDFRenderer(this.environment, entityResolver, formatPlan).buildXslFoGenerator();
    }
}

