/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt.resolve;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.jdocbook.xslt.resolve.BasicUrnResolver;

public class ExplicitUrnResolver
extends BasicUrnResolver {
    private final String name;

    public ExplicitUrnResolver(Environment environment, String name, String stylesheetResource) throws XSLTException {
        super(environment, "urn:docbook:stylesheet", ExplicitUrnResolver.createSource(environment, name, stylesheetResource));
        this.name = name;
    }

    private static Source createSource(Environment environment, String name, String stylesheetResource) throws XSLTException {
        URL stylesheet = environment.getResourceHelper().requireResource(stylesheetResource);
        try {
            return new StreamSource(stylesheet.openStream(), stylesheet.toExternalForm());
        }
        catch (IOException e) {
            throw new XSLTException("could not locate DocBook stylesheet [" + name + "]", e);
        }
    }

    public String toString() {
        return super.toString() + " [" + this.name + "]";
    }
}

