/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt.resolve;

import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class ClasspathResolver
implements URIResolver {
    public static final String SCHEME = "classpath:";
    private final ClassLoader classLoader;

    public ClasspathResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (!href.startsWith(SCHEME)) {
            return null;
        }
        try {
            String urlStr = href.substring(SCHEME.length());
            URL url = this.classLoader.getResource(urlStr);
            if (url == null && urlStr.startsWith("/")) {
                url = this.classLoader.getResource(urlStr.substring(1));
            }
            if (url != null) {
                return new StreamSource(url.openStream(), url.toExternalForm());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new TransformerException("Unable to resolve requested classpath URL [" + href + "]");
    }
}

