/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeResolutionListener;
import org.codehaus.plexus.logging.Logger;
import org.jboss.jdocbook.Configuration;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.MasterLanguageDescriptor;
import org.jboss.jdocbook.ResourceDelegate;
import org.jboss.jdocbook.ValueInjection;
import org.jboss.jdocbook.profile.ProfilingSource;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.RenderingSource;
import org.jboss.jdocbook.translate.TranslationSource;
import org.jboss.jdocbook.util.ResourceDelegateSupport;
import org.jboss.jdocbook.util.TranslationUtils;
import org.jboss.jdocbook.util.XIncludeHelper;
import org.jboss.jdocbook.xslt.XSLTException;
import org.jboss.maven.plugins.jdocbook.DirectoryLayout;
import org.jboss.maven.plugins.jdocbook.Format;
import org.jboss.maven.plugins.jdocbook.Injection;
import org.jboss.maven.plugins.jdocbook.Matcher;
import org.jboss.maven.plugins.jdocbook.MojoInternalConfigSupport;
import org.jboss.maven.plugins.jdocbook.Options;
import org.jboss.maven.plugins.jdocbook.Profiling;
import org.jboss.maven.util.logging.PlexusToMavenPluginLoggingBridge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDocBookMojo
extends MojoInternalConfigSupport
implements DirectoryLayout.BaseInfo {
    public static final String PLUGIN_NAME = "jdocbook";
    protected String sourceDocumentName;
    protected File sourceDirectory;
    protected File baseOutputDirectory;
    protected Resource imageResource;
    protected Resource cssResource;
    protected File fontsDirectory;
    protected Format[] formats;
    protected boolean attach = true;
    protected Profiling profiling = new Profiling();
    protected Options options;
    protected Injection[] injections;
    protected boolean ignoreTranslations;
    protected String masterTranslation;
    protected String[] translations;
    protected final DirectoryLayout directoryLayout = new DirectoryLayout(this);
    private Locale masterLanguageLocale;
    private File rootMasterSourceFile;
    private JDocBookComponentRegistry jDocBookComponentRegistry;
    private MasterLanguageDescriptorImpl masterLanguageDescriptor = new MasterLanguageDescriptorImpl();

    @Override
    public File getBaseSourceDirectory() {
        return this.sourceDirectory;
    }

    @Override
    public File getBaseOutputDirectory() {
        return this.baseOutputDirectory;
    }

    protected void process() throws JDocBookProcessException {
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.options == null) {
            this.options = new Options();
        }
        if (this.translations == null) {
            this.translations = new String[0];
        }
        try {
            if (this.settings.getActiveProxy() != null) {
                this.doExecuteWithProxy(this.settings.getActiveProxy());
            } else {
                this.doExecute();
            }
        }
        catch (XSLTException e) {
            throw new MojoExecutionException("XSLT problem", (Exception)((Object)e));
        }
        catch (RenderingException e) {
            throw new MojoExecutionException("Rendering problem", (Exception)((Object)e));
        }
        catch (JDocBookProcessException e) {
            throw new MojoExecutionException("Unexpected problem", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecuteWithProxy(Proxy proxy) throws JDocBookProcessException {
        String originalHost = null;
        String originalPort = null;
        String originalUser = null;
        String originalPswd = null;
        if (!this.empty(proxy.getHost())) {
            originalHost = System.getProperty("http.proxyHost");
            System.setProperty("http.proxyHost", proxy.getHost());
            originalPort = System.getProperty("http.proxyPort");
            System.setProperty("http.proxyPort", Integer.toString(proxy.getPort()));
        }
        if (!this.empty(proxy.getUsername())) {
            originalUser = System.getProperty("http.proxyUser");
            System.setProperty("http.proxyUser", this.emptyStringIfNull(proxy.getUsername()));
        }
        if (!this.empty(proxy.getPassword())) {
            originalPswd = System.getProperty("http.proxyPassword");
            System.setProperty("http.proxyPassword", this.emptyStringIfNull(proxy.getPassword()));
        }
        try {
            this.doExecute();
        }
        finally {
            if (!this.empty(proxy.getHost())) {
                System.setProperty("http.proxyHost", this.emptyStringIfNull(originalHost));
                System.setProperty("http.proxyPort", this.emptyStringIfNull(originalPort));
            }
            if (!this.empty(proxy.getUsername())) {
                System.setProperty("http.proxyUser", this.emptyStringIfNull(originalUser));
            }
            if (!this.empty(proxy.getPassword())) {
                System.setProperty("http.proxyPassword", this.emptyStringIfNull(originalPswd));
            }
        }
    }

    private boolean empty(String string) {
        return string == null || "".equals(string);
    }

    private String emptyStringIfNull(String string) {
        return string == null ? "" : string;
    }

    protected void doExecute() throws JDocBookProcessException {
        this.process();
    }

    protected String getRequestedFormat() {
        String requestedFormat = this.session.getExecutionProperties().getProperty("jdocbook.format");
        if (requestedFormat != null) {
            this.getLog().debug((CharSequence)("requested processing limited to [" + requestedFormat + "] format"));
        }
        return requestedFormat;
    }

    protected Locale getRequestedLanguageLocale() {
        Locale requestedLocale;
        String requestedLocaleStr = this.session.getExecutionProperties().getProperty("jdocbook.lang");
        Locale locale = requestedLocale = requestedLocaleStr == null ? null : this.parseLocale(requestedLocaleStr);
        if (requestedLocale != null) {
            this.getLog().debug((CharSequence)("requested processing limited to [" + this.stringify(requestedLocale) + "] lang"));
        }
        return requestedLocale;
    }

    public File[] getFontDirectories() {
        File stagedFontsDirectory;
        ArrayList<File> directories = new ArrayList<File>();
        if (this.fontsDirectory != null && this.fontsDirectory.exists()) {
            directories.add(this.fontsDirectory);
        }
        if ((stagedFontsDirectory = new File(this.directoryLayout.getStagingDirectory(), "fonts")).exists()) {
            directories.add(stagedFontsDirectory);
        }
        return directories.toArray(new File[directories.size()]);
    }

    protected List<Artifact> collectArtifactsByType(String type, boolean transitivesFirst) {
        Set dependencyArtifacts = this.project.getArtifacts();
        dependencyArtifacts.addAll(this.pluginArtifacts);
        DependencyTreeResolutionListener listener = new DependencyTreeResolutionListener((Logger)new PlexusToMavenPluginLoggingBridge(this.getLog()));
        try {
            this.artifactCollector.collect(dependencyArtifacts, this.project.getArtifact(), this.project.getManagedVersionMap(), this.localRepository, this.project.getRemoteArtifactRepositories(), this.artifactMetadataSource, null, Collections.singletonList(listener));
        }
        catch (AbstractArtifactResolutionException e) {
            throw new JDocBookProcessException("Cannot build project dependency tree", (Throwable)e);
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        this.processNode(listener.getRootNode(), artifacts, type, transitivesFirst);
        return artifacts;
    }

    private void processNode(DependencyNode node, List<Artifact> artifacts, String type, boolean transitivesFirst) {
        Artifact artifact = node.getArtifact();
        boolean isProjectArtifact = this.project.getArtifact().getId().equals(artifact.getId());
        if (!isProjectArtifact) {
            this.resolveArtifact(artifact);
        }
        if (!isProjectArtifact && !transitivesFirst && this.include(node.getArtifact(), type)) {
            artifacts.add(node.getArtifact());
        }
        for (DependencyNode child : node.getChildren()) {
            this.processNode(child, artifacts, type, transitivesFirst);
        }
        if (!isProjectArtifact && transitivesFirst && this.include(node.getArtifact(), type)) {
            artifacts.add(node.getArtifact());
        }
    }

    private void resolveArtifact(Artifact artifact) {
        try {
            this.artifactResolver.resolve(artifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new JDocBookProcessException("Unable to resolve artifact [" + artifact.getId() + "]", (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new JDocBookProcessException("Unable to locate artifact [" + artifact.getId() + "]", (Throwable)e);
        }
    }

    private boolean include(Artifact artifact, String matchingType) {
        return matchingType.equals(artifact.getType());
    }

    protected Locale parseLocale(String locale) {
        return TranslationUtils.parse((String)locale, (char)this.options.getLocaleSeparator());
    }

    protected String stringify(Locale locale) {
        return TranslationUtils.render((Locale)locale, (char)this.options.getLocaleSeparator());
    }

    @Override
    public String getMasterLanguage() {
        return this.masterTranslation;
    }

    protected Locale getMasterLanguageLocale() {
        if (this.masterLanguageLocale == null) {
            this.masterLanguageLocale = this.fromLanguageString(this.getMasterLanguage());
        }
        return this.masterLanguageLocale;
    }

    private boolean isMasterLanguage(String language) {
        return this.getMasterLanguage().equals(language);
    }

    private boolean isMasterLanguage(Locale language) {
        return this.getMasterLanguageLocale().equals(language);
    }

    protected File getRootMasterSourceFile() {
        if (this.rootMasterSourceFile == null) {
            this.rootMasterSourceFile = new File(this.directoryLayout.getMasterSourceDirectory(), this.sourceDocumentName);
        }
        return this.rootMasterSourceFile;
    }

    protected File getSourceDocument(Locale languageLocale) {
        return this.getSourceDocument(this.stringify(languageLocale));
    }

    protected File getSourceDocument(String language) {
        return this.isMasterLanguage(language) ? this.getRootMasterSourceFile() : new File(this.directoryLayout.getTranslationDirectory(language), this.sourceDocumentName);
    }

    protected File getProfiledDocument(Locale languageLocale) {
        return this.getProfiledDocument(this.stringify(languageLocale));
    }

    protected File getProfiledDocument(String language) {
        return new File(this.directoryLayout.getProfilingDirectory(language), this.sourceDocumentName);
    }

    protected List<Format> getFormatOptionsList() {
        return Arrays.asList(this.formats);
    }

    protected Format getFormatOptions(String name) {
        for (Format format : this.formats) {
            if (!name.equals(format.getName())) continue;
            return format;
        }
        return null;
    }

    protected List<PublishingSource> resolvePublishingSources() {
        ArrayList<PublishingSource> sources = new ArrayList<PublishingSource>();
        if (this.ignoreTranslations) {
            this.getLog().info((CharSequence)"Skipping all translations");
            sources.add(new PublishingSource(this.getMasterLanguageLocale()));
        } else {
            Matcher<Locale> matcher = new Matcher<Locale>(this.getRequestedLanguageLocale());
            if (matcher.matches(this.getMasterLanguageLocale())) {
                sources.add(new PublishingSource(this.getMasterLanguageLocale()));
            } else {
                this.getLog().debug((CharSequence)"skipping master language");
            }
            for (String language : this.translations) {
                Locale languageLocale = this.fromLanguageString(language);
                if (matcher.matches(languageLocale)) {
                    sources.add(new PublishingSource(languageLocale));
                    continue;
                }
                this.getLog().debug((CharSequence)("skipping language " + language));
            }
        }
        return sources;
    }

    protected JDocBookComponentRegistry getComponentRegistry() {
        if (this.jDocBookComponentRegistry == null) {
            this.jDocBookComponentRegistry = this.buildComponentRegistry();
        }
        return this.jDocBookComponentRegistry;
    }

    private JDocBookComponentRegistry buildComponentRegistry() {
        return new JDocBookComponentRegistry((Environment)new EnvironmentImpl(), (Configuration)new ConfigurationImpl());
    }

    private ClassLoader buildResourceDelegateClassLoader() {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (this.directoryLayout.getStagingDirectory().exists()) {
            try {
                urls.add(this.directoryLayout.getStagingDirectory().toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new JDocBookProcessException("Unable to resolve staging directory to URL", (Throwable)e);
            }
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getFile() == null) continue;
            try {
                urls.add(artifact.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLog().warn((CharSequence)("Uanble to retrieve artifact url [" + artifact.getId() + "]"));
            }
        }
        if (this.pluginArtifacts != null) {
            for (Artifact artifact : this.pluginArtifacts) {
                if (artifact.getFile() == null) continue;
                try {
                    urls.add(artifact.getFile().toURI().toURL());
                }
                catch (MalformedURLException e) {
                    this.getLog().warn((CharSequence)("Uanble to retrieve artifact url [" + artifact.getId() + "]"));
                }
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
    }

    public MasterLanguageDescriptorImpl getMasterLanguageDescriptor() {
        return this.masterLanguageDescriptor;
    }

    public List<TranslationSource> getTranslationSources(boolean excludeIgnoredTranslations) {
        boolean skipAllTranslations;
        ArrayList<TranslationSource> result = new ArrayList<TranslationSource>();
        Locale requestedLocale = this.getRequestedLanguageLocale();
        boolean requestedLocaleIsTranslation = requestedLocale != null && !this.stringify(requestedLocale).equals(this.masterTranslation);
        boolean bl = skipAllTranslations = this.ignoreTranslations && excludeIgnoredTranslations && !requestedLocaleIsTranslation;
        if (skipAllTranslations) {
            this.getLog().info((CharSequence)"Skipping all translations");
        } else {
            for (String localeStr : this.translations) {
                boolean skipThisLocale;
                Locale locale = this.parseLocale(localeStr);
                boolean bl2 = skipThisLocale = requestedLocale != null && !requestedLocale.equals(locale) && excludeIgnoredTranslations;
                if (skipThisLocale) {
                    this.getLog().debug((CharSequence)("skipping non-requested lang [" + localeStr + "]"));
                    continue;
                }
                result.add(new TranslationSourceImpl(localeStr));
            }
        }
        return result;
    }

    public Locale fromLanguageString(String languageStr) {
        return TranslationUtils.parse((String)languageStr, (char)this.options.getLocaleSeparator());
    }

    private class TranslationSourceImpl
    implements TranslationSource {
        private final String language;
        private final Locale languageLocale;

        private TranslationSourceImpl(String language) {
            this.language = language;
            this.languageLocale = AbstractDocBookMojo.this.fromLanguageString(language);
        }

        public Locale getLanguage() {
            return this.languageLocale;
        }

        public File resolvePoDirectory() {
            return AbstractDocBookMojo.this.directoryLayout.getTranslationSourceDirectory(this.language);
        }

        public File resolveTranslatedXmlDirectory() {
            return AbstractDocBookMojo.this.directoryLayout.getTranslationDirectory(this.language);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationImpl
    implements Configuration {
        private LinkedHashSet<ValueInjection> valueInjections;
        private LinkedHashSet<String> catalogSet;

        private ConfigurationImpl() {
        }

        private Options options() {
            return AbstractDocBookMojo.this.options;
        }

        public Properties getTransformerParameters() {
            return this.options().getTransformerParameters();
        }

        public boolean isUseRelativeImageUris() {
            return this.options().isUseRelativeImageUris();
        }

        public char getLocaleSeparator() {
            return this.options().getLocaleSeparator();
        }

        public boolean isAutoDetectFontsEnabled() {
            return this.options().isAutoDetectFontsEnabled();
        }

        public boolean isUseFopFontCacheEnabled() {
            return this.options().isUseFopFontCache();
        }

        public LinkedHashSet<ValueInjection> getValueInjections() {
            if (this.valueInjections == null) {
                this.valueInjections = new LinkedHashSet();
                this.valueInjections.addAll(this.getValueInjections());
                if (this.options().isApplyStandardInjectionValues()) {
                    this.valueInjections.add(new ValueInjection("version", AbstractDocBookMojo.this.project.getVersion()));
                    SimpleDateFormat dateFormat = new SimpleDateFormat(this.options().getInjectionDateFormat());
                    this.valueInjections.add(new ValueInjection("today", dateFormat.format(new Date())));
                }
            }
            return this.valueInjections;
        }

        public LinkedHashSet<String> getCatalogs() {
            if (this.catalogSet == null) {
                this.catalogSet = new LinkedHashSet();
                for (String catalog : this.options().getCatalogs()) {
                    this.catalogSet.add(catalog);
                }
            }
            return this.catalogSet;
        }

        public org.jboss.jdocbook.Profiling getProfiling() {
            return AbstractDocBookMojo.this.profiling;
        }

        public String getDocBookVersion() {
            return AbstractDocBookMojo.this.options.getDocbookVersion();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MasterLanguageDescriptorImpl
    implements MasterLanguageDescriptor {
        private File rootMasterFile;
        private Set<File> masterFiles;

        private MasterLanguageDescriptorImpl() {
        }

        public Locale getLanguage() {
            return AbstractDocBookMojo.this.fromLanguageString(AbstractDocBookMojo.this.masterTranslation);
        }

        public File getPotDirectory() {
            return AbstractDocBookMojo.this.directoryLayout.getPotSourceDirectory();
        }

        public File getBaseSourceDirectory() {
            return AbstractDocBookMojo.this.directoryLayout.getMasterSourceDirectory();
        }

        public File getRootDocumentFile() {
            if (this.rootMasterFile == null) {
                this.rootMasterFile = new File(this.getBaseSourceDirectory(), AbstractDocBookMojo.this.sourceDocumentName);
            }
            return this.rootMasterFile;
        }

        public Set<File> getDocumentFiles() {
            if (this.masterFiles == null) {
                File rootMasterFile = this.getRootDocumentFile();
                TreeSet<File> files = new TreeSet<File>();
                files.add(rootMasterFile);
                XIncludeHelper.findAllInclusionFiles((File)rootMasterFile, files);
                this.masterFiles = Collections.unmodifiableSet(files);
            }
            return this.masterFiles;
        }
    }

    private class ResourceDelegateImpl
    extends ResourceDelegateSupport {
        private ClassLoader loader;

        private ResourceDelegateImpl() {
        }

        protected ClassLoader getResourceClassLoader() {
            if (this.loader == null) {
                this.loader = AbstractDocBookMojo.this.buildResourceDelegateClassLoader();
            }
            return this.loader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnvironmentImpl
    implements Environment {
        private final ResourceDelegateImpl resourceDelegate;

        private EnvironmentImpl() {
            this.resourceDelegate = new ResourceDelegateImpl();
        }

        public ResourceDelegate getResourceDelegate() {
            return this.resourceDelegate;
        }

        public MasterLanguageDescriptor getMasterLanguageDescriptor() {
            return AbstractDocBookMojo.this.getMasterLanguageDescriptor();
        }

        public File getWorkDirectory() {
            return AbstractDocBookMojo.this.directoryLayout.getRootJDocBookWorkDirectory();
        }

        public File getStagingDirectory() {
            return AbstractDocBookMojo.this.directoryLayout.getStagingDirectory();
        }

        public List<File> getFontDirectories() {
            return Arrays.asList(AbstractDocBookMojo.this.getFontDirectories());
        }

        public Environment.DocBookXsltResolutionStrategy getDocBookXsltResolutionStrategy() {
            return Environment.DocBookXsltResolutionStrategy.NAMED;
        }
    }

    protected class PublishingSource
    implements ProfilingSource,
    RenderingSource {
        private final Locale languageLocale;

        public PublishingSource(Locale languageLocale) {
            this.languageLocale = languageLocale;
        }

        public Locale getLanguage() {
            return this.languageLocale;
        }

        public File resolveDocumentFile() {
            return AbstractDocBookMojo.this.getSourceDocument(this.getLanguage());
        }

        public File resolveProfiledDocumentFile() {
            return AbstractDocBookMojo.this.getProfiledDocument(this.languageLocale);
        }

        public File resolveSourceDocument() {
            return AbstractDocBookMojo.this.profiling.isEnabled() ? AbstractDocBookMojo.this.getProfiledDocument(this.languageLocale) : AbstractDocBookMojo.this.getSourceDocument(this.languageLocale);
        }

        public File resolvePublishingBaseDirectory() {
            return AbstractDocBookMojo.this.directoryLayout.getPublishBaseDirectory(AbstractDocBookMojo.this.stringify(this.languageLocale));
        }

        public File getXslFoDirectory() {
            return null;
        }
    }
}

