/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.jdocbook;

import java.io.File;
import org.jboss.jdocbook.JDocBookProcessException;

public class DirectoryLayout {
    private final BaseInfo baseInfo;
    private File targetDirectory;
    private File stagingDirectory;
    private File rootJDocBookWorkDirectory;
    private File rootJDocBookTranslationWorkDirectory;
    private File rootJDocBookProfileWorkDirectory;
    private File rootPublishDirectory;
    private File xslFoDirectory;

    public DirectoryLayout(BaseInfo baseInfo) {
        this.baseInfo = baseInfo;
    }

    private boolean hasTranslations() {
        return this.baseInfo.getMasterLanguage() != null && !"".equals(this.baseInfo.getMasterLanguage());
    }

    private void ensureTranslations() {
        if (!this.hasTranslations()) {
            throw new JDocBookProcessException("Project did not define language support");
        }
    }

    public File getMasterSourceDirectory() {
        return this.hasTranslations() ? this.getTranslationSourceDirectory(this.baseInfo.getMasterLanguage()) : this.baseInfo.getBaseSourceDirectory();
    }

    public File getPotSourceDirectory() {
        this.ensureTranslations();
        return this.getTranslationSourceDirectory("pot");
    }

    public File getTranslationSourceDirectory(String language) {
        this.ensureTranslations();
        return new File(this.baseInfo.getBaseSourceDirectory(), language);
    }

    private File getTargetDirectory() {
        if (this.targetDirectory == null) {
            this.targetDirectory = new File(this.baseInfo.getBaseOutputDirectory(), "docbook");
        }
        return this.targetDirectory;
    }

    public File getStagingDirectory() {
        if (this.stagingDirectory == null) {
            this.stagingDirectory = new File(this.getTargetDirectory(), "staging");
        }
        return this.stagingDirectory;
    }

    public File getRootJDocBookWorkDirectory() {
        if (this.rootJDocBookWorkDirectory == null) {
            this.rootJDocBookWorkDirectory = new File(this.getTargetDirectory(), "work");
        }
        return this.rootJDocBookWorkDirectory;
    }

    private File getRootJDocBookTranslationWorkDirectory() {
        if (this.rootJDocBookTranslationWorkDirectory == null) {
            this.rootJDocBookTranslationWorkDirectory = new File(this.getRootJDocBookWorkDirectory(), "translate");
        }
        return this.rootJDocBookTranslationWorkDirectory;
    }

    public File getTranslationDirectory(String language) {
        return new File(this.getRootJDocBookTranslationWorkDirectory(), language);
    }

    private File getRootJDocBookProfileWorkDirectory() {
        if (this.rootJDocBookProfileWorkDirectory == null) {
            this.rootJDocBookProfileWorkDirectory = new File(this.getRootJDocBookWorkDirectory(), "profile");
        }
        return this.rootJDocBookProfileWorkDirectory;
    }

    public File getProfilingDirectory(String language) {
        return new File(this.getRootJDocBookProfileWorkDirectory(), language);
    }

    private File getRootPublishDirectory() {
        if (this.rootPublishDirectory == null) {
            this.rootPublishDirectory = new File(this.getTargetDirectory(), "publish");
        }
        return this.rootPublishDirectory;
    }

    public File getPublishBaseDirectory(String language) {
        return new File(this.getRootPublishDirectory(), language);
    }

    public File getPublishDirectory(String language, String format) {
        return new File(this.getPublishBaseDirectory(language), format);
    }

    public File getXslFoDirectory() {
        if (this.xslFoDirectory == null) {
            this.xslFoDirectory = new File(this.getRootJDocBookWorkDirectory(), "xsl-fo");
        }
        return this.xslFoDirectory;
    }

    public static interface BaseInfo {
        public String getMasterLanguage();

        public File getBaseSourceDirectory();

        public File getBaseOutputDirectory();
    }
}

