/*
 * Copyright (c) 2007, Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, v. 2.1. This program is distributed in the
 * hope that it will be useful, but WITHOUT A WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details. You should have received a
 * copy of the GNU Lesser General Public License, v.2.1 along with this
 * distribution; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Red Hat Author(s): Steve Ebersole
 */
package org.jboss.maven.plugins.test.ext;

import java.util.ArrayList;
import java.util.List;

/**
 * Structured representation of an <environment/> definition.
 *
 * @author Steve Ebersole
 */
public class Environment {
	private final String name;
	private List dependencies = new ArrayList();
	private List resources = new ArrayList();

	public Environment(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public List getDependencies() {
		return dependencies;
	}

	public List getResources() {
		return resources;
	}
}
