/*
 * Copyright (c) 2007, Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, v. 2.1. This program is distributed in the
 * hope that it will be useful, but WITHOUT A WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details. You should have received a
 * copy of the GNU Lesser General Public License, v.2.1 along with this
 * distribution; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Red Hat Author(s): Steve Ebersole
 */
package org.jboss.maven.shared.xml.dom4j;

import org.dom4j.Element;

/**
 * Simple support class for Extracter implementations.
 *
 * @author Steve Ebersole
 */
public abstract class ExtracterSupport implements Extracter {
	private final boolean required;
	private final String defaultValue;

	protected ExtracterSupport(boolean required, String defaultValue) {
		this.required = required;
		this.defaultValue = defaultValue;
	}

	public final String extract(Element element) {
		String value = null;
		if ( element != null ) {
			value = extractValue( element );
		}
		if ( value == null ) {
			if ( required ) {
				requiredMissing();
			}
			return defaultValue;
		}
		else {
			return value;
		}
	}

	/**
	 * Extract the value according to the underlying implementations
	 * contract.  The given element is guarenteed to not be null.
	 *
	 * @param element The non-null element.
	 * @return The extracted value.
	 */
	protected abstract String extractValue(Element element);

	/**
	 * Indicates that the implementation requires this value,
	 * but that null was encountered.
	 */
	protected void requiredMissing() {
		throw new IllegalStateException( "Required setting missing" );
	}
}
