/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mcann.indexer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.jboss.mcann.AnnotationRepository;
import org.jboss.mcann.AnnotationScanner;
import org.jboss.mcann.AnnotationScannerFactory;
import org.jboss.mcann.indexer.FileUtil;

public class Main {
    private static Logger log = Logger.getLogger(Main.class.getName());

    public void store(AnnotationRepository ari, File directory) throws Exception {
        if (ari == null) {
            throw new IllegalArgumentException("ARI is null");
        }
        if (directory == null || !directory.exists()) {
            throw new IllegalArgumentException("Directory is null");
        }
        File file = new File(directory, "mcann.ser");
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        ObjectOutputStream oos = new ObjectOutputStream(gos);
        oos.writeObject(ari);
        oos.flush();
        oos.close();
    }

    private static void usage() {
        System.out.println("Usage: Indexer <input-jar> <output-jar>");
    }

    public static void main(String[] args) {
        try {
            if (args.length == 2) {
                Main m = new Main();
                File input = new File(args[0]);
                File output = new File(args[1]);
                File tmp = new File(System.getProperty("java.io.tmpdir"));
                File root = FileUtil.extract(input, tmp);
                File destination = new File(root, "META-INF");
                AnnotationScanner as = AnnotationScannerFactory.getStrategy((int)0);
                URL[] urls = new URL[]{input.toURI().toURL()};
                URLClassLoader ucl = new URLClassLoader(urls);
                AnnotationRepository ari = as.scan((ClassLoader)ucl, urls);
                m.store(ari, destination);
                FileUtil.compress(root, output);
                FileUtil.recursiveDelete(root);
            } else {
                Main.usage();
            }
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getMessage(), t);
        }
    }
}

