/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.integration.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.core.security.CheckType;
import org.jboss.messaging.core.security.JBMSecurityManager;
import org.jboss.messaging.core.security.Role;
import org.jboss.messaging.core.server.MessagingComponent;
import org.jboss.messaging.integration.security.SecurityActions;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASSecurityManager
implements JBMSecurityManager,
MessagingComponent {
    private static final Logger log = Logger.getLogger(JBossASSecurityManager.class);
    private boolean trace = log.isTraceEnabled();
    private RealmMapping realmMapping;
    private AuthenticationManager authenticationManager;
    private String securityDomainName = "java:/jaas/messaging";
    private boolean started;

    public boolean validateUser(String user, String password) {
        SimplePrincipal principal = new SimplePrincipal(user);
        char[] passwordChars = null;
        if (password != null) {
            passwordChars = password.toCharArray();
        }
        Subject subject = new Subject();
        return this.authenticationManager.isValid((Principal)principal, (Object)passwordChars, subject);
    }

    public boolean validateUserAndRole(String user, String password, Set<Role> roles, CheckType checkType) {
        Subject subject;
        boolean authenticated;
        SimplePrincipal principal = user == null ? null : new SimplePrincipal(user);
        char[] passwordChars = null;
        if (password != null) {
            passwordChars = password.toCharArray();
        }
        if (authenticated = this.authenticationManager.isValid((Principal)principal, (Object)passwordChars, subject = new Subject())) {
            SecurityActions.pushSubjectContext((Principal)principal, passwordChars, subject, this.securityDomainName);
            Set<Principal> rolePrincipals = this.getRolePrincipals(checkType, roles);
            authenticated = this.realmMapping.doesUserHaveRole((Principal)principal, rolePrincipals);
            if (this.trace) {
                log.trace((Object)("user " + user + (authenticated ? " is " : " is NOT ") + "authorized"));
            }
            SecurityActions.popSubjectContext();
        }
        return authenticated;
    }

    public void addRole(String user, String role) {
    }

    public void addUser(String user, String password) {
    }

    public void removeRole(String user, String role) {
    }

    public void removeUser(String user) {
    }

    public void setDefaultUser(String username) {
    }

    private Set<Principal> getRolePrincipals(CheckType checkType, Set<Role> roles) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (Role role : roles) {
            if (!checkType.hasRole(role)) continue;
            principals.add((Principal)new SimplePrincipal(role.getName()));
        }
        return principals;
    }

    public void setRealmMapping(RealmMapping realmMapping) {
        this.realmMapping = realmMapping;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        InitialContext ic = new InitialContext();
        this.authenticationManager = (AuthenticationManager)ic.lookup(this.securityDomainName);
        this.realmMapping = (RealmMapping)this.authenticationManager;
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public void setSecurityDomainName(String securityDomainName) {
        this.securityDomainName = securityDomainName;
    }
}

