/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra;

import javax.resource.spi.ConnectionRequestInfo;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.ra.JBMRAProperties;
import org.jboss.messaging.ra.Util;

public class JBMConnectionRequestInfo
implements ConnectionRequestInfo {
    private static final Logger log = Logger.getLogger(JBMConnectionRequestInfo.class);
    private static boolean trace = log.isTraceEnabled();
    private String userName;
    private String password;
    private String clientID;
    private boolean useXA;
    private final int type;
    private final boolean transacted;
    private final int acknowledgeMode;

    public JBMConnectionRequestInfo(JBMRAProperties prop, int type) {
        if (trace) {
            log.trace((Object)("constructor(" + prop + ")"));
        }
        this.userName = prop.getUserName();
        this.password = prop.getPassword();
        this.clientID = prop.getClientID();
        this.useXA = prop.isUseXA();
        this.type = type;
        this.transacted = true;
        this.acknowledgeMode = 1;
    }

    public JBMConnectionRequestInfo(int type) {
        if (trace) {
            log.trace((Object)("constructor(" + type + ")"));
        }
        this.type = type;
        this.transacted = true;
        this.acknowledgeMode = 1;
    }

    public JBMConnectionRequestInfo(boolean transacted, int acknowledgeMode, int type) {
        if (trace) {
            log.trace((Object)("constructor(" + transacted + ", " + acknowledgeMode + ", " + type + ")"));
        }
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.type = type;
    }

    public void setDefaults(JBMRAProperties prop) {
        if (trace) {
            log.trace((Object)("setDefaults(" + prop + ")"));
        }
        if (this.userName == null) {
            this.userName = prop.getUserName();
        }
        if (this.password == null) {
            this.password = prop.getPassword();
        }
        if (this.clientID == null) {
            this.clientID = prop.getClientID();
        }
        this.useXA = prop.isUseXA();
    }

    public String getUserName() {
        if (trace) {
            log.trace((Object)"getUserName()");
        }
        return this.userName;
    }

    public void setUserName(String userName) {
        if (trace) {
            log.trace((Object)("setUserName(" + userName + ")"));
        }
        this.userName = userName;
    }

    public String getPassword() {
        if (trace) {
            log.trace((Object)"getPassword()");
        }
        return this.password;
    }

    public void setPassword(String password) {
        if (trace) {
            log.trace((Object)"setPassword(****)");
        }
        this.password = password;
    }

    public String getClientID() {
        if (trace) {
            log.trace((Object)"getClientID()");
        }
        return this.clientID;
    }

    public void setClientID(String clientID) {
        if (trace) {
            log.trace((Object)("setClientID(" + clientID + ")"));
        }
        this.clientID = clientID;
    }

    public int getType() {
        if (trace) {
            log.trace((Object)"getType()");
        }
        return this.type;
    }

    public boolean isUseXA() {
        if (trace) {
            log.trace((Object)"isUseXA()");
        }
        return this.useXA;
    }

    public boolean isTransacted() {
        if (trace) {
            log.trace((Object)"isTransacted()");
        }
        return this.transacted;
    }

    public int getAcknowledgeMode() {
        if (trace) {
            log.trace((Object)"getAcknowledgeMode()");
        }
        return this.acknowledgeMode;
    }

    public boolean equals(Object obj) {
        if (trace) {
            log.trace((Object)("equals(" + obj + ")"));
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JBMConnectionRequestInfo) {
            JBMConnectionRequestInfo you = (JBMConnectionRequestInfo)obj;
            return Util.compare(this.userName, you.getUserName()) && Util.compare(this.password, you.getPassword()) && Util.compare(this.clientID, you.getClientID()) && this.type == you.getType() && this.useXA == you.isUseXA() && this.transacted == you.isTransacted() && this.acknowledgeMode == you.getAcknowledgeMode();
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            log.trace((Object)"hashCode()");
        }
        int hash = 7;
        hash += 31 * hash + (this.userName != null ? this.userName.hashCode() : 0);
        hash += 31 * hash + (this.password != null ? this.password.hashCode() : 0);
        hash += 31 * hash + Integer.valueOf(this.type).hashCode();
        hash += 31 * hash + (this.useXA ? 1 : 0);
        hash += 31 * hash + (this.transacted ? 1 : 0);
        hash += 31 * hash + Integer.valueOf(this.acknowledgeMode).hashCode();
        return hash;
    }
}

