/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra;

import java.io.Serializable;
import java.util.Map;
import javax.jms.Queue;
import javax.jms.Topic;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.ra.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBMMCFProperties
implements Serializable {
    static final long serialVersionUID = -5951352236582886862L;
    private static final Logger log = Logger.getLogger(JBMMCFProperties.class);
    private static boolean trace = log.isTraceEnabled();
    private static final String QUEUE_TYPE = Queue.class.getName();
    private static final String TOPIC_TYPE = Topic.class.getName();
    private Map<String, Object> connectionParameters;
    public String strConnectionParameters;
    private String connectorClassName;
    private int type = 0;
    private Integer useTryLock;

    public JBMMCFProperties() {
        if (trace) {
            log.trace((Object)"constructor()");
        }
        this.useTryLock = null;
    }

    public int getType() {
        if (trace) {
            log.trace((Object)"getType()");
        }
        return this.type;
    }

    public String getConnectionParameters() {
        return this.strConnectionParameters;
    }

    public Map<String, Object> getParsedConnectionParameters() {
        return this.connectionParameters;
    }

    public void setConnectionParameters(String configuration) {
        this.strConnectionParameters = configuration;
        this.connectionParameters = Util.parseConfig(configuration);
    }

    public String getConnectorClassName() {
        return this.connectorClassName;
    }

    public void setConnectorClassName(String value) {
        this.connectorClassName = value;
    }

    public void setSessionDefaultType(String defaultType) {
        if (trace) {
            log.trace((Object)("setSessionDefaultType(" + this.type + ")"));
        }
        this.type = defaultType.equals(QUEUE_TYPE) ? 1 : (defaultType.equals(TOPIC_TYPE) ? 2 : 0);
    }

    public String getSessionDefaultType() {
        if (trace) {
            log.trace((Object)"getSessionDefaultType()");
        }
        if (this.type == 0) {
            return "BOTH";
        }
        if (this.type == 1) {
            return TOPIC_TYPE;
        }
        return QUEUE_TYPE;
    }

    public Integer getUseTryLock() {
        if (trace) {
            log.trace((Object)"getUseTryLock()");
        }
        return this.useTryLock;
    }

    public void setUseTryLock(Integer useTryLock) {
        if (trace) {
            log.trace((Object)("setUseTryLock(" + useTryLock + ")"));
        }
        this.useTryLock = useTryLock;
    }

    public boolean equals(Object obj) {
        if (trace) {
            log.trace((Object)("equals(" + obj + ")"));
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof JBMMCFProperties) {
            JBMMCFProperties you = (JBMMCFProperties)obj;
            return this.type == you.getType() && Util.compare(this.useTryLock, you.getUseTryLock());
        }
        return false;
    }

    public int hashCode() {
        if (trace) {
            log.trace((Object)"hashCode()");
        }
        int hash = 7;
        hash += 31 * hash + Integer.valueOf(this.type).hashCode();
        hash += 31 * hash + (this.useTryLock != null ? this.useTryLock.hashCode() : 0);
        return hash;
    }
}

