/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.ra;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ResourceAllocationException;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.messaging.core.logging.Logger;
import org.jboss.messaging.ra.JBMConnectionRequestInfo;
import org.jboss.messaging.ra.JBMCredential;
import org.jboss.messaging.ra.JBMLocalTransaction;
import org.jboss.messaging.ra.JBMManagedConnectionFactory;
import org.jboss.messaging.ra.JBMMetaData;
import org.jboss.messaging.ra.JBMSession;
import org.jboss.messaging.ra.JBMXAResource;

public class JBMManagedConnection
implements ManagedConnection,
ExceptionListener {
    private static final Logger log = Logger.getLogger(JBMManagedConnection.class);
    private static boolean trace = log.isTraceEnabled();
    private final JBMManagedConnectionFactory mcf;
    private final JBMConnectionRequestInfo cri;
    private final String userName;
    private final String password;
    private final AtomicBoolean isDestroyed = new AtomicBoolean(false);
    private final List<ConnectionEventListener> eventListeners;
    private final Set<JBMSession> handles;
    private ReentrantLock lock = new ReentrantLock();
    private Connection connection;
    private XAConnection xaConnection;
    private Session session;
    private TopicSession topicSession;
    private QueueSession queueSession;
    private XASession xaSession;
    private XATopicSession xaTopicSession;
    private XAQueueSession xaQueueSession;
    private XAResource xaResource;

    public JBMManagedConnection(JBMManagedConnectionFactory mcf, JBMConnectionRequestInfo cri, String userName, String password) throws ResourceException {
        if (trace) {
            log.trace((Object)("constructor(" + mcf + ", " + cri + ", " + userName + ", ****)"));
        }
        this.mcf = mcf;
        this.cri = cri;
        this.userName = userName;
        this.password = password;
        this.eventListeners = Collections.synchronizedList(new ArrayList());
        this.handles = Collections.synchronizedSet(new HashSet());
        this.connection = null;
        this.xaConnection = null;
        this.session = null;
        this.topicSession = null;
        this.queueSession = null;
        this.xaSession = null;
        this.xaTopicSession = null;
        this.xaQueueSession = null;
        this.xaResource = null;
        try {
            this.setup();
        }
        catch (Throwable t) {
            try {
                this.destroy();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            throw new ResourceException("Error during setup", t);
        }
    }

    public synchronized Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (trace) {
            log.trace((Object)("getConnection(" + subject + ", " + cxRequestInfo + ")"));
        }
        JBMCredential credential = JBMCredential.getCredential(this.mcf, subject, cxRequestInfo);
        if (this.userName != null && !this.userName.equals(credential.getUserName())) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (this.userName == null && credential.getUserName() != null) {
            throw new SecurityException("Password credentials not the same, reauthentication not allowed");
        }
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("The managed connection is already destroyed");
        }
        JBMSession session = new JBMSession(this, (JBMConnectionRequestInfo)cxRequestInfo);
        this.handles.add(session);
        return session;
    }

    private void destroyHandles() throws ResourceException {
        if (trace) {
            log.trace((Object)"destroyHandles()");
        }
        try {
            if (this.xaConnection != null) {
                this.xaConnection.stop();
            }
            if (this.connection != null) {
                this.connection.stop();
            }
        }
        catch (Throwable t) {
            log.trace((Object)"Ignored error stopping connection", t);
        }
        for (JBMSession session : this.handles) {
            session.destroy();
        }
        this.handles.clear();
    }

    public void destroy() throws ResourceException {
        if (trace) {
            log.trace((Object)"destroy()");
        }
        if (this.isDestroyed.get() || this.xaConnection == null && this.connection == null) {
            return;
        }
        this.isDestroyed.set(true);
        try {
            if (this.xaConnection != null) {
                this.xaConnection.setExceptionListener(null);
            } else {
                this.connection.setExceptionListener(null);
            }
        }
        catch (JMSException e) {
            log.debug((Object)("Error unsetting the exception listener " + this), (Throwable)e);
        }
        this.destroyHandles();
        try {
            try {
                if (this.topicSession != null) {
                    this.topicSession.close();
                }
                if (this.xaTopicSession != null) {
                    this.xaTopicSession.close();
                }
                if (this.queueSession != null) {
                    this.queueSession.close();
                }
                if (this.xaQueueSession != null) {
                    this.xaQueueSession.close();
                }
                if (this.session != null) {
                    this.session.close();
                }
                if (this.xaSession != null) {
                    this.xaSession.close();
                }
            }
            catch (JMSException e) {
                log.debug((Object)("Error closing session " + this), (Throwable)e);
            }
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.xaConnection != null) {
                this.xaConnection.close();
            }
        }
        catch (Throwable e) {
            throw new ResourceException("Could not properly close the session and connection", e);
        }
    }

    public void cleanup() throws ResourceException {
        if (trace) {
            log.trace((Object)"cleanup()");
        }
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("ManagedConnection already destroyed");
        }
        this.destroyHandles();
        this.lock = new ReentrantLock();
    }

    public void associateConnection(Object obj) throws ResourceException {
        if (trace) {
            log.trace((Object)("associateConnection(" + obj + ")"));
        }
        if (this.isDestroyed.get() || !(obj instanceof JBMSession)) {
            throw new IllegalStateException("ManagedConnection in an illegal state");
        }
        JBMSession h = (JBMSession)obj;
        h.setManagedConnection(this);
        this.handles.add(h);
    }

    protected void lock() {
        if (trace) {
            log.trace((Object)"lock()");
        }
        this.lock.lock();
    }

    protected void tryLock() throws JMSException {
        Integer tryLock;
        if (trace) {
            log.trace((Object)"tryLock()");
        }
        if ((tryLock = this.mcf.getUseTryLock()) == null || tryLock <= 0) {
            this.lock();
            return;
        }
        try {
            if (!this.lock.tryLock(tryLock.intValue(), TimeUnit.SECONDS)) {
                throw new ResourceAllocationException("Unable to obtain lock in " + tryLock + " seconds: " + this);
            }
        }
        catch (InterruptedException e) {
            throw new ResourceAllocationException("Interrupted attempting lock: " + this);
        }
    }

    protected void unlock() {
        if (trace) {
            log.trace((Object)"unlock()");
        }
        this.lock.unlock();
    }

    public void addConnectionEventListener(ConnectionEventListener l) {
        if (trace) {
            log.trace((Object)("addConnectionEventListener(" + l + ")"));
        }
        this.eventListeners.add(l);
    }

    public void removeConnectionEventListener(ConnectionEventListener l) {
        if (trace) {
            log.trace((Object)("removeConnectionEventListener(" + l + ")"));
        }
        this.eventListeners.remove(l);
    }

    public XAResource getXAResource() throws ResourceException {
        if (trace) {
            log.trace((Object)"getXAResource()");
        }
        if (this.xaConnection == null) {
            throw new NotSupportedException("Non XA transaction not supported");
        }
        if (this.xaResource == null) {
            this.xaResource = this.xaTopicSession != null ? this.xaTopicSession.getXAResource() : (this.xaQueueSession != null ? this.xaQueueSession.getXAResource() : this.xaSession.getXAResource());
        }
        if (trace) {
            log.trace((Object)("XAResource=" + this.xaResource));
        }
        this.xaResource = new JBMXAResource(this, this.xaResource);
        return this.xaResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (trace) {
            log.trace((Object)"getLocalTransaction()");
        }
        JBMLocalTransaction tx = new JBMLocalTransaction(this);
        if (trace) {
            log.trace((Object)("LocalTransaction=" + tx));
        }
        return tx;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (trace) {
            log.trace((Object)"getMetaData()");
        }
        if (this.isDestroyed.get()) {
            throw new IllegalStateException("The managed connection is already destroyed");
        }
        return new JBMMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (trace) {
            log.trace((Object)("setLogWriter(" + out + ")"));
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (trace) {
            log.trace((Object)"getLogWriter()");
        }
        return null;
    }

    public void onException(JMSException exception) {
        if (trace) {
            log.trace((Object)("onException(" + (Object)((Object)exception) + ")"));
        }
        if (this.isDestroyed.get()) {
            if (trace) {
                log.trace((Object)("Ignoring error on already destroyed connection " + this), (Throwable)exception);
            }
            return;
        }
        log.warn((Object)("Handling JMS exception failure: " + this), (Throwable)exception);
        try {
            if (this.xaConnection != null) {
                this.xaConnection.setExceptionListener(null);
            } else {
                this.connection.setExceptionListener(null);
            }
        }
        catch (JMSException e) {
            log.debug((Object)"Unable to unset exception listener", (Throwable)e);
        }
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, (Exception)((Object)exception));
        this.sendEvent(event);
    }

    protected boolean isXA() {
        if (trace) {
            log.trace((Object)"isXA()");
        }
        return this.xaConnection != null;
    }

    protected XASession getXASession() {
        if (trace) {
            log.trace((Object)"getXASession()");
        }
        if (this.isXA()) {
            if (this.xaTopicSession != null) {
                return this.xaTopicSession;
            }
            if (this.xaQueueSession != null) {
                return this.xaQueueSession;
            }
            return this.xaSession;
        }
        return null;
    }

    protected Session getSession() {
        if (trace) {
            log.trace((Object)"getSession()");
        }
        if (this.topicSession != null) {
            return this.topicSession;
        }
        if (this.queueSession != null) {
            return this.queueSession;
        }
        return this.session;
    }

    protected void sendEvent(ConnectionEvent event) {
        ConnectionEventListener[] list;
        if (trace) {
            log.trace((Object)("sendEvent(" + event + ")"));
        }
        int type = event.getId();
        block7: for (ConnectionEventListener l : list = this.eventListeners.toArray(new ConnectionEventListener[this.eventListeners.size()])) {
            switch (type) {
                case 1: {
                    l.connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    l.localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    l.localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    l.localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    l.connectionErrorOccurred(event);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Illegal eventType: " + type);
                }
            }
        }
    }

    protected void removeHandle(JBMSession handle) {
        if (trace) {
            log.trace((Object)("removeHandle(" + handle + ")"));
        }
        this.handles.remove(handle);
    }

    protected JBMConnectionRequestInfo getCRI() {
        if (trace) {
            log.trace((Object)"getCRI()");
        }
        return this.cri;
    }

    protected JBMManagedConnectionFactory getManagedConnectionFactory() {
        if (trace) {
            log.trace((Object)"getManagedConnectionFactory()");
        }
        return this.mcf;
    }

    void start() throws JMSException {
        if (trace) {
            log.trace((Object)"start()");
        }
        if (this.connection != null) {
            this.connection.start();
        }
        if (this.xaConnection != null) {
            this.xaConnection.start();
        }
    }

    void stop() throws JMSException {
        if (trace) {
            log.trace((Object)"stop()");
        }
        if (this.xaConnection != null) {
            this.xaConnection.stop();
        }
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    protected String getUserName() {
        if (trace) {
            log.trace((Object)"getUserName()");
        }
        return this.userName;
    }

    private void setup() throws ResourceException {
        if (trace) {
            log.trace((Object)"setup()");
        }
        try {
            boolean transacted = this.cri.isTransacted();
            int acknowledgeMode = 1;
            if (this.cri.getType() == 2) {
                if (this.cri.isUseXA()) {
                    this.xaConnection = this.userName != null && this.password != null ? this.mcf.getJBossConnectionFactory().createXATopicConnection(this.userName, this.password) : this.mcf.getJBossConnectionFactory().createXATopicConnection();
                    this.xaConnection.setExceptionListener((ExceptionListener)this);
                    this.xaTopicSession = ((XATopicConnection)this.xaConnection).createXATopicSession();
                    this.topicSession = this.xaTopicSession.getTopicSession();
                } else {
                    this.connection = this.userName != null && this.password != null ? this.mcf.getJBossConnectionFactory().createTopicConnection(this.userName, this.password) : this.mcf.getJBossConnectionFactory().createTopicConnection();
                    this.connection.setExceptionListener((ExceptionListener)this);
                    this.topicSession = ((TopicConnection)this.connection).createTopicSession(transacted, acknowledgeMode);
                }
            } else if (this.cri.getType() == 1) {
                if (this.cri.isUseXA()) {
                    this.xaConnection = this.userName != null && this.password != null ? this.mcf.getJBossConnectionFactory().createXAQueueConnection(this.userName, this.password) : this.mcf.getJBossConnectionFactory().createXAQueueConnection();
                    this.xaConnection.setExceptionListener((ExceptionListener)this);
                    this.xaQueueSession = ((XAQueueConnection)this.xaConnection).createXAQueueSession();
                    this.queueSession = this.xaQueueSession.getQueueSession();
                } else {
                    this.connection = this.userName != null && this.password != null ? this.mcf.getJBossConnectionFactory().createQueueConnection(this.userName, this.password) : this.mcf.getJBossConnectionFactory().createQueueConnection();
                    this.connection.setExceptionListener((ExceptionListener)this);
                    this.queueSession = ((QueueConnection)this.connection).createQueueSession(transacted, acknowledgeMode);
                }
            } else if (this.cri.isUseXA()) {
                this.xaConnection = this.userName != null && this.password != null ? this.mcf.getJBossConnectionFactory().createXAConnection(this.userName, this.password) : this.mcf.getJBossConnectionFactory().createXAConnection();
                this.xaConnection.setExceptionListener((ExceptionListener)this);
                this.xaSession = this.xaConnection.createXASession();
                this.session = this.xaSession.getSession();
            } else {
                this.connection = this.userName != null && this.password != null ? this.mcf.getJBossConnectionFactory().createConnection(this.userName, this.password) : this.mcf.getJBossConnectionFactory().createConnection();
                this.connection.setExceptionListener((ExceptionListener)this);
                this.session = this.connection.createSession(transacted, acknowledgeMode);
            }
        }
        catch (JMSException je) {
            throw new ResourceException(je.getMessage(), (Throwable)je);
        }
    }
}

